#include <stdint.h>

#include <e_dma.h>

static void dma(e_tcb_t *tcb)
{
	while (e_dma_busy(E_DMA_0));

        tcb->config       = E_DMA_DOUBLE | E_DMA_MASTER | E_DMA_ENABLE;
        tcb->inner_stride = 0x00080008;
        tcb->count        = 0x00010400;
        tcb->outer_stride = 0x00000000;
#if 1
        tcb->src_addr     = (void*)0x8e000000;
        tcb->dst_addr     = (void*)0x3000;
#else
        tcb->dst_addr     = (void*)0x8e000000;
        tcb->src_addr     = (void*)0x3000;
#endif

        e_dma_start(E_DMA_0, tcb);
}

int main(int argc, char *argv[])
{
	volatile int *cnt = (int*)0x2000;
	e_tcb_t _tcb;

	*cnt = 0;

	while (1) {
		dma(&_tcb);
		*cnt = *cnt + 1;
	}

	return 0;
}


