
#include <stdio.h>
#include <stdint.h>
#include <math.h>

#include <e-hal.h>
#include <e-loader.h>


int main(int argc, char *argv[])
{
        Epiphany_t _epiphany, *epiphany = &_epiphany;
        int rv;

	e_set_host_verbosity(0);
	e_set_loader_verbosity(0);

	rv = e_load("../epiphany/main.srec", 1, 0, 1);
	if (rv == EPI_ERR) {
		fprintf(stderr, "[!] Error loading Epiphany program.\n");
		return -1;
	}

        rv = e_open(epiphany);
        if (rv) {
                fprintf(stderr, "[!] Failed to open epiphany\n");
                return -1;
        }

	unsigned int r0 = e_read_word(epiphany, rv, 0x2000);
	sleep(5);
	unsigned int r1 = e_read_word(epiphany, rv, 0x2000);

	printf("%d - %d\n", r1 - r0, (int)roundf((600e6 * 5.0f) / (r1 - r0)));

        e_close(epiphany);

        return 0;
}
