library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity SDT028ATFTip_v1_0 is
  generic (
    -- Users to add parameters here
    -- User parameters ends

    -- Parameters of Axi Slave Bus Interface S00_AXIS
    C_S00_AXIS_TDATA_WIDTH  : integer  := 32
  );
  port (
    -- Users to add ports here
    data : inout std_logic_vector(7 downto 0);
    csx : out std_logic;
    wrx : out std_logic;
    dcx : out std_logic;
    rdx : out std_logic;
    resx : out std_logic;
    -- User ports ends

    -- Ports of Axi Slave Bus Interface S00_AXIS
    s00_axis_aclk  : in std_logic;
    s00_axis_aresetn  : in std_logic;
    s00_axis_tready  : out std_logic;
    s00_axis_tdata  : in std_logic_vector(C_S00_AXIS_TDATA_WIDTH-1 downto 0);
    s00_axis_tstrb  : in std_logic_vector((C_S00_AXIS_TDATA_WIDTH/8)-1 downto 0);
    s00_axis_tlast  : in std_logic;
    s00_axis_tvalid  : in std_logic
  );
end SDT028ATFTip_v1_0;

architecture arch_imp of SDT028ATFTip_v1_0 is
    signal data_out : std_logic_vector(7 downto 0);
    signal data_in : std_logic_vector(7 downto 0);
    signal control : std_logic;
    
  -- component declaration
  component SDT028ATFTip_v1_0_S00_AXIS is
    generic (
    C_S_AXIS_TDATA_WIDTH  : integer  := 32
    );
    port (
    data_out : out std_logic_vector(7 downto 0);
    control : buffer std_logic;
    csx : out std_logic;
    wrx : out std_logic;
    dcx : out std_logic;
    rdx : out std_logic;
    resx : out std_logic;
    S_AXIS_ACLK  : in std_logic;
    S_AXIS_ARESETN  : in std_logic;
    S_AXIS_TREADY  : out std_logic;
    S_AXIS_TDATA  : in std_logic_vector(C_S_AXIS_TDATA_WIDTH-1 downto 0);
    S_AXIS_TSTRB  : in std_logic_vector((C_S_AXIS_TDATA_WIDTH/8)-1 downto 0);
    S_AXIS_TLAST  : in std_logic;
    S_AXIS_TVALID  : in std_logic
    );
  end component SDT028ATFTip_v1_0_S00_AXIS;

begin
  data <= data_out when control = '0' else "ZZZZZZZZ";
  data_in <= data;
  
-- Instantiation of Axi Bus Interface S00_AXIS
SDT028ATFTip_v1_0_S00_AXIS_inst : SDT028ATFTip_v1_0_S00_AXIS
  generic map (
    C_S_AXIS_TDATA_WIDTH  => C_S00_AXIS_TDATA_WIDTH
  )
  port map (
    data_out => data_out,
    control => control,
    csx => csx,
    wrx => wrx,
    dcx => dcx,
    rdx => rdx,
    resx => resx,
    S_AXIS_ACLK  => s00_axis_aclk,
    S_AXIS_ARESETN  => s00_axis_aresetn,
    S_AXIS_TREADY  => s00_axis_tready,
    S_AXIS_TDATA  => s00_axis_tdata,
    S_AXIS_TSTRB  => s00_axis_tstrb,
    S_AXIS_TLAST  => s00_axis_tlast,
    S_AXIS_TVALID  => s00_axis_tvalid
  );

  -- Add user logic here

  -- User logic ends

end arch_imp;
