/******************************************************************************
  Target Script for Zynq-7000

  Copyright (c) 2014 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Connect()
{  
  // CPU0 components  
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80090000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80091000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80098000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x8009c000);
 
  // Shared components
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80001000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80002000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80003000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80004000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80005000);

  // Memory regions that can't be accessed by the AHB access point
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0x00000000, 0x40000);  // OCM appears to be cached
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0x00100000, 0x3FF00000);  // DDR 
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0xE0000000, 0x30000);  // IOP
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0xF8900000, 0x603000); // CPU private registers
}

function Reset()
{
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.delay(100);
  TargetInterface.stop(400);
}

function DDRReset()
{
  Reset();
  TargetInterface.pokeBinary(0x00018000, "$(TargetsDir)/MicroZed/init_ps7_7010.bin");
  TargetInterface.runFromAddress(0x00018000, 2000); 
}

function Connect1()
{  
  // CPU1 components 
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80092000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80093000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x80099000);
  TargetInterface.setDebugInterfaceProperty("component_base", 0x8009d000);

  // Memory regions that can't be accessed by the AHB access point
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0x00000000, 0x40000);  // OCM appears to be cached
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0x00100000, 0x3FF00000);  // DDR
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0xE0000000, 0x30000);  // IOP
  TargetInterface.setDebugInterfaceProperty("use_adiv5_AHB", 0, 0xF8900000, 0x603000); // CPU private registers
}

function Reset1()
{
  TargetInterface.stop(400);
}

