
typedef void (*ISR_FN_t)(void);

#ifndef NULL
#define NULL		0
#endif 

#define TRUE 1
#define FALSE 0

#define RET_OK 0
#define RET_ERR 1

#define TOTAL_SPI_PORT 2
#define SPI0 0
#define SPI1 1

#define TOTAL_XAXIDMA_PORT 1
#define XAXIDMA0 0

// common RGB color definitions
#define BLACK           0x0000      //   0,   0,   0
#define BLUE            0x001F      //   0,   0, 255
#define GREEN           0x07E0      //   0, 255,   0
#define CYAN            0x07FF      //   0, 255, 255
#define RED             0xF800      // 255,   0,   0
#define MAGENTA         0xF81F      // 255,   0, 255
#define YELLOW          0xFFE0      // 255, 255,   0
#define WHITE           0xFFFF      // 255, 255, 255

#define TFT_WIDTH 240
#define TFT_HEIGHT 320

#define UINT8 unsigned char
#define UINT16 unsigned short
#define UINT32 unsigned int

typedef unsigned char BOOL;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef void (*CALLBACK_FPN)(void* arg);

#define global_interrupts_disable() __asm volatile("cpsid i")
#define global_interrupts_enable() __asm volatile("cpsie i") 

// prototypes
BOOL CPU_INTC_ActivateInterrupt(UINT32 Irq_Index, CALLBACK_FPN ISR, void* ISR_Param);
BOOL CPU_INTC_DeactivateInterrupt(UINT32 Irq_Index);
void CPU_INTC_Initialize();
