
#ifndef ILI9341_REGS_H_
#define ILI9341_REGS_H_

// Level 1 Commands (from the display Datasheet)
#define CMD_NOP                             0x00
#define CMD_SOFTWARE_RESET                  0x01
#define CMD_READ_DISP_ID                    0x04
#define CMD_READ_DISP_STATUS                0x09
#define CMD_READ_DISP_MADCTRL               0x0B
#define CMD_READ_DISP_PIXEL_FORMAT          0x0C
#define CMD_READ_DISP_IMAGE_FORMAT          0x0D
#define CMD_READ_DISP_SIGNAL_MODE           0x0E
#define CMD_READ_DISP_SELF_DIAGNOSTIC       0x0F
#define CMD_ENTER_SLEEP_MODE                0x10
#define CMD_SLEEP_OUT                       0x11
#define CMD_PARTIAL_MODE_ON                 0x12
#define CMD_NORMAL_DISP_MODE_ON             0x13
#define CMD_DISP_INVERSION_OFF              0x20
#define CMD_DISP_INVERSION_ON               0x21
#define CMD_GAMMA_SET                       0x26
#define CMD_DISPLAY_OFF                     0x28
#define CMD_DISPLAY_ON                      0x29
#define CMD_COLUMN_ADDRESS_SET              0x2A
#define CMD_PAGE_ADDRESS_SET                0x2B
#define CMD_MEMORY_WRITE                    0x2C
#define CMD_COLOR_SET                       0x2D
#define CMD_MEMORY_READ                     0x2E
#define CMD_PARTIAL_AREA                    0x30
#define CMD_VERT_SCROLL_DEFINITION          0x33
#define CMD_TEARING_EFFECT_LINE_OFF         0x34
#define CMD_TEARING_EFFECT_LINE_ON          0x35
#define CMD_MEMORY_ACCESS_CONTROL           0x36
#define CMD_VERT_SCROLL_START_ADDRESS       0x37
#define CMD_IDLE_MODE_OFF                   0x38
#define CMD_IDLE_MODE_ON                    0x39
#define CMD_COLMOD_PIXEL_FORMAT_SET         0x3A
#define CMD_WRITE_MEMORY_CONTINUE           0x3C
#define CMD_READ_MEMORY_CONTINUE            0x3E
#define CMD_SET_TEAR_SCANLINE               0x44
#define CMD_GET_SCANLINE                    0x45
#define CMD_WRITE_DISPLAY_BRIGHTNESS        0x51
#define CMD_READ_DISPLAY_BRIGHTNESS         0x52
#define CMD_WRITE_CTRL_DISPLAY              0x53
#define CMD_READ_CTRL_DISPLAY               0x54
#define CMD_WRITE_CONTENT_ADAPT_BRIGHTNESS  0x55
#define CMD_READ_CONTENT_ADAPT_BRIGHTNESS   0x56
#define CMD_WRITE_MIN_CAB_LEVEL             0x5E
#define CMD_READ_MIN_CAB_LEVEL              0x5F
#define CMD_READ_ID1                        0xDA
#define CMD_READ_ID2                        0xDB
#define CMD_READ_ID3                        0xDC

// Level 2 Commands (from the display Datasheet)
#define CMD_RGB_SIGNAL_CONTROL              0xB0
#define CMD_FRAME_RATE_CONTROL_NORMAL       0xB1
#define CMD_FRAME_RATE_CONTROL_IDLE_8COLOR  0xB2
#define CMD_FRAME_RATE_CONTROL_PARTIAL      0xB3
#define CMD_DISPLAY_INVERSION_CONTROL       0xB4
#define CMD_BLANKING_PORCH_CONTROL          0xB5
#define CMD_DISPLAY_FUNCTION_CONTROL        0xB6
#define CMD_ENTRY_MODE_SET                  0xB7
#define CMD_BACKLIGHT_CONTROL_1             0xB8
#define CMD_BACKLIGHT_CONTROL_2             0xB9
#define CMD_BACKLIGHT_CONTROL_3             0xBA
#define CMD_BACKLIGHT_CONTROL_4             0xBB
#define CMD_BACKLIGHT_CONTROL_5             0xBC
#define CMD_BACKLIGHT_CONTROL_6             0xBD
#define CMD_BACKLIGHT_CONTROL_7             0xBE
#define CMD_BACKLIGHT_CONTROL_8             0xBF
#define CMD_POWER_CONTROL_1                 0xC0
#define CMD_POWER_CONTROL_2                 0xC1
#define CMD_VCOM_CONTROL_1                  0xC5
#define CMD_VCOM_CONTROL_2                  0xC7
#define CMD_POWER_CONTROL_A                 0xCB
#define CMD_POWER_CONTROL_B                 0xCF
#define CMD_NVMEM_WRITE                     0xD0
#define CMD_NVMEM_PROTECTION_KEY            0xD1
#define CMD_NVMEM_STATUS_READ               0xD2
#define CMD_READ_ID4                        0xD3
#define CMD_POSITIVE_GAMMA_CORRECTION       0xE0
#define CMD_NEGATIVE_GAMMA_CORRECTION       0xE1
#define CMD_DIGITAL_GAMMA_CONTROL_1         0xE2
#define CMD_DIGITAL_GAMMA_CONTROL_2         0xE3
#define CMD_DRIVER_TIMING_CONTROL_A         0xE8
#define CMD_DRIVER_TIMING_CONTROL_B         0xEA
#define CMD_POWER_ON_SEQ_CONTROL            0xED
#define CMD_ENABLE_3_GAMMA_CONTROL          0xF2
#define CMD_INTERFACE_CONTROL               0xF6
#define CMD_PUMP_RATIO_CONTROL              0xF7

#endif /* ILI9341_REGS_H_ */
