/****************************************************************************
 * DTFT - DisplayTech SDT028ATFT display (ILI9341 TFT controller)
 *
 * File              : main.c
 * This copy created : Oct 10, 2014
 * Version           : 1.1
 * Description       : LCD drivers test
 ***************************************************************************/
#include <__cross_studio_io.h>
#include "defs.h"
#include "ps7_init.h"

extern int XAXIDMA_init(int xaxidmaNum);
extern int tft_init();
extern int tft_cls(int color);
extern void Xil_DCacheEnable(void);

ISR_FN_t interrupt_handlers[160];

int main() {

  ps7_init();  // comment-out if running from DDR

  global_interrupts_disable();
  CPU_INTC_Initialize();

  if (XAXIDMA_init(XAXIDMA0) != RET_OK) {
    debug_printf("XAXIDMA Initialization failed\r\n");
    return RET_ERR;
  }
  global_interrupts_enable(); 
  Xil_DCacheEnable();

  if (tft_init() != RET_OK) {
    debug_printf("TFT Initialization failed\r\n");
    return RET_ERR;
  }
  for (;;) {
    tft_cls(BLACK);
    tft_cls(BLUE);
    tft_cls(GREEN);
    tft_cls(CYAN);
    tft_cls(RED);
    tft_cls(MAGENTA);
    tft_cls(YELLOW);
    tft_cls(WHITE);
  }
}
