
// Direct Register Mode Register Address Map
typedef struct {
  UINT32 MM2S_DMACR;       // MM2S DMA Control Register
  UINT32 MM2S_DMASR;       // MM2S DMA Status Register
  UINT32 Reserved1;
  UINT32 Reserved2;
  UINT32 Reserved3;
  UINT32 Reserved4;
  UINT32 MM2S_SA;          // MM2S Source Address
  UINT32 Reserved5;
  UINT32 Reserved6;
  UINT32 Reserved7;
  UINT32 MM2S_LENGTH;      // MM2S Transfer Length (Bytes)
} XAXIDMA_Type;

#define XAXIDMA_MAX_TRANSFER_LEN 0x7FFFFF  // Max length hw supports

#define XAXIDMA_HALTED_MASK 0x00000001     // DMA channel halted
#define XAXIDMA_IDLE_MASK 0x00000002       // DMA channel idle
#define XAXIDMA_CR_RUNSTOP_MASK	0x00000001 // Start/stop DMA channel
#define XAXIDMA_CR_RESET_MASK 0x00000004   // Reset DMA engine

#define XAXIDMA_IRQ_IOC_MASK 0x00001000   // Completion intr
#define XAXIDMA_IRQ_DELAY_MASK 0x00002000 // Delay interrupt
#define XAXIDMA_IRQ_ERROR_MASK 0x00004000 // Error interrupt
#define XAXIDMA_IRQ_ALL_MASK 0x00007000   // All interrupts
