#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <e-hal.h>


int main(int argc, char *argv[])
{
	unsigned row, col, coreid, i;
	e_platform_t platform;
	e_epiphany_t dev;
	e_mem_t emem;

	srand(1);

	e_init(NULL);
	e_reset_system();
	e_get_platform_info(&platform);

	
		row = rand() % platform.rows;
		col = rand() % platform.cols;


		//CREATE INTEGER
		int num = 5;

		//SHOW VALUE BEFORE CHANGE
		fprintf(stderr, "num = %d\n", num);

		//WRITE IN SHARE MEMORY
		e_write(&dev, 0, 0, 0x6000, &num, sizeof(num));
		
		
		e_open(&dev, row, col, 1, 1);
		e_reset_group(&dev);
		e_load("e_hello_world.srec", &dev, 0, 0, E_TRUE);
		

		//WAIT CORE CHANGE VALUE
		usleep(100000);

		//READ INTEGER
		e_read(&dev, 0, 0, 0x6000, &num, sizeof(num));

		//SHOW VALUE AFTER CHANGE
		fprintf(stderr, "num = %d\n\n", num);

	       	e_close(&dev);


	e_free(&emem);
	e_finalize();

	return 0;
}

