#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <e-hal.h>

int main()
{
  //INICIALIZAR EL SISTEMA
  e_init(NULL);
  e_reset_system();

  //RESERVAR DE MEMORIA COMPARTIDA
  e_mem_t emem;
  e_alloc(&emem, 0x01000000, 128);

  //ESTABLECER GRUPO DE TRABAJO
  e_epiphany_t dev;
  e_open(&dev, 0, 0, 1, 1);
  e_reset_group(&dev);

  //CARGAR EJECUTABLE EN EL NUCLEO
  e_load("e_dma.srec", &dev, 0, 0, E_FALSE);

  //ESCRIBE EN LA MEMORIA EXTERNA (TOTAL = 55)
  int num[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
  e_write(&emem, 0, 0, 0x0, &num, sizeof(num));
		
  //ARRANCA EL PROGRAMA
  e_start(&dev, 0, 0);
		
  //DEJO QUE EL NUCLEO HAGA SU TRABAJO
  usleep(100000);

  //LEER EL DATO DE LA  MEMORIA EXTERNA
  e_read(&emem, 0, 0, 0x0, &num, sizeof(num));  

  //MOSTRAR DATO EN PANTALLA
  printf("total = %d\n\n", num[0]);  
	

  //TAREAS DE FINALIZACIÓN
  e_close(&dev);
  e_free(&emem);
  e_finalize();

  return 0;
}

