#include <stdlib.h>
#include "e_lib.h"

//MEMORIA EXTERNA COMPARTIDA
int buffer[128] SECTION("shared_dram");

int main(void) 
{
  //MEMORIA LOCAL
  int numeros[10];

  //LIMPIO LOS DATO PARA QUE NO HAYA DUDAS
  int i, total=0;
  for(i=0;i<10;i++){    
    numeros[i] = 0;
  }

  //DESCRIPTOR
  e_dma_desc_t descriptor;
  e_dma_set_desc(
     E_DMA_0,
     //E_DMA_ENABLE|E_DMA_MASTER|E_DMA_WORD|E_DMA_MSGMODE,
     E_DMA_ENABLE|E_DMA_MASTER|E_DMA_WORD,
     0x0000,
     0x0004, 0x0004, //PASO, SALTO EN BYTES HASTA EL SIGUIENTE DATO
     0x000A, 0x0001, //CONTADORES: A=10 EN HEXADECIMAL
     0x0000, 0x0000, //PARECEN NO UTILIZARSE EN ESTE EJEMPLO
     buffer, numeros,
     &descriptor);
		 	  
  //INICIO LA TRANSFERENCIA
  e_dma_start(&descriptor, E_DMA_0);

  //ESPERO A QUE ACABE LA TRANSFERENCIA
  e_dma_wait(E_DMA_0);

  //SUMAMOS LOS NÚMEROS
  for(i=0;i<10;i++){
    total += numeros[i];
  }

  //DEVOLVEMOS EL RESULTADO POR LA MEMORIA EXTERNA
  buffer[0] = total;
  buffer[0] = numeros[0];


  return EXIT_SUCCESS;
}
