#!/bin/bash

set -e

ESDK=${EPIPHANY_HOME}
ELIBS=${ESDK}/tools/host/lib
EINCS=${ESDK}/tools/host/include
ELDF=${ESDK}/bsps/current/fast.ldf

# Build HOST side application
gcc src/host.c -o bin/host.elf -I ${EINCS} -L ${ELIBS} -le-hal

# Build DEVICE side program
e-gcc -T ${ELDF} src/e_add.c -o bin/e_add.elf -le-lib
e-gcc -T ${ELDF} src/e_mul.c -o bin/e_mul.elf -le-lib


# Convert ebinary to SREC file
e-objcopy --srec-forceS3 --output-target srec bin/e_add.elf bin/e_add.srec
e-objcopy --srec-forceS3 --output-target srec bin/e_mul.elf bin/e_mul.srec

