#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <e-lib.h>

char outbuf[128] SECTION("shared_dram");

int  main() 
{
  volatile e_barrier_t barriers[3];
  e_barrier_t *tgt_bars[3];
  e_barrier_init(barriers, tgt_bars);

  unsigned  int *num1, *num2, *result, *cid, *prod, core_addr1, core_addr2, *p;
  e_coreid_t coreid;
  coreid = e_get_coreid();


  result = (unsigned int *) 0x2000;
  num1 = (unsigned int *) 0x3000;
  num2 = (unsigned int *) 0x3200;
  cid = (unsigned int *) 0x4000;

  if(coreid == 2056 || coreid == 2057)
  {
    *cid = coreid;
    *result = *num1 + *num2;
    e_barrier(barriers, tgt_bars);
  }
  else
  {
    p = (unsigned int *) 0x00000000;
    core_addr1 = (unsigned int ) e_get_global_address(0,0, p);
    core_addr2 = (unsigned int ) e_get_global_address(0,1, p);

    cid= (unsigned int *) 0x4000;
    prod = (unsigned int *) 0x7000;
    *cid = coreid;

    num1=(unsigned int *) (core_addr1 + (unsigned int)0x2000);
    num2=(unsigned int *) (core_addr2 + (unsigned int)0x2000);

    e_barrier(barriers, tgt_bars);

    *prod = *num1 * *num2;
    sprintf(outbuf, "From 0x%03x! val %d total no %d", coreid, *prod);
  }

  return EXIT_SUCCESS;
}
