#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <e-hal.h>

#define _BufSize   (128)
#define _BufOffset (0x01000000)

int main() 
{
  e_platform_t platform;
  e_epiphany_t dev;
  e_mem_t emem;
  unsigned char  emsg[_BufSize];
  unsigned int cid, result, i, no[2];

  for(i=0; i<2; i++){
    printf("Enter %d Number: \n",(i+1));
    scanf("%d", &no[i]);
  }

  e_init(NULL);
  e_reset_system();
  e_get_platform_info(&platform);
  e_alloc(&emem, _BufOffset, _BufSize);
  e_open(&dev, 0, 0, 1, 3); 
  e_reset_group(&dev);

  for(i=0; i<2; i++){
    e_write(&dev, 0, i, 0x3000, &no[0],sizeof(int));
    e_write(&dev, 0, i, 0x3200, &no[1],sizeof(int));
  }

  e_load_group("e_add.srec", &dev, 0, 0, 1, 3, E_TRUE);
  //e_load("e_mul.srec", &dev, 0, 2, E_TRUE);

  for(i=0; i<2; i++){
    e_read(&dev, 0, i, 0x2000, &result, sizeof(int) );
    printf("Addition Result: %0d \n", result);
    e_read(&dev, 0, i, 0x4000, &cid, sizeof(int) );
    printf("from: %03x \n", cid);
  }

  
  e_read(&dev, 0, 2, 0x7000, &result, sizeof(int) );
  printf("Multiplication Result: %0d \n", result);
  e_read(&dev, 0, 2, 0x4000, &cid, sizeof(int) );
  printf("from: %03x  \n", cid);

  e_read(&emem, 0, 2, 0x0, emsg, _BufSize);
  fprintf(stderr, "\"%s\"\n", emsg);
  

  fflush(stdout);

  e_close(&dev);
  e_free(&emem);
  e_finalize();

  return 0;
}
