#include <stdint.h>
#include <string.h>

#include <e_dma.h>


//#define SENTINEL

static void dma(e_tcb_t *tcb)
{
	char volatile *last_addr;
	char sentinel;

	while (e_dma_busy(E_DMA_0));

        tcb->config       = E_DMA_DOUBLE | E_DMA_MASTER | E_DMA_ENABLE;
        tcb->inner_stride = 0x00080008;
        tcb->count        = 0x00010400;
        tcb->outer_stride = 0x00000000;
#if 1
        tcb->src_addr     = (void*)0x8e000000;
        tcb->dst_addr     = (void*)0x3000;
#else
        tcb->dst_addr     = (void*)0x8e000000;
        tcb->src_addr     = (void*)0x3000;
#endif

#ifdef SENTINEL
	last_addr  = (char *) tcb->src_addr + ((0x400 - 1) * 8);
	sentinel = ~(*last_addr);
#endif

        e_dma_start(E_DMA_0, tcb);

#ifdef SENTINEL
	while (*last_addr == sentinel)
	{
		__asm__ __volatile__ ("nop");
	}
#endif
}

int main(int argc, char *argv[])
{
	volatile int *cnt = (int*)0x2000;
	volatile int *active = (int*)0x2004;
	e_tcb_t _tcb;

	*cnt = 0;
	*active = 0;

	while (!*active);

	while (*active) {
		dma(&_tcb);
		*cnt = *cnt + 1;
	}

	while (e_dma_busy(E_DMA_0));

	*cnt = 0;

	return 0;
}


