
#include <stdio.h>
#include <stdint.h>
#include <math.h>
#include <unistd.h>
#include <sys/time.h>

#include <e-hal.h>
#include <e-loader.h>

static inline uint32_t
e_read_u32(e_epiphany_t *dev, unsigned row, unsigned col, off_t from_addr)
{
	uint32_t rv;
	e_read(dev, row, col, from_addr, &rv, sizeof(uint32_t));
	return rv;
}

static inline void
e_write_u32(e_epiphany_t *dev, unsigned row, unsigned col, off_t to_addr, uint32_t val)
{
	e_write(dev, row, col, to_addr, &val, sizeof(uint32_t));
}


static void
do_write_tests(e_epiphany_t *dev)
{
	int i, j;

	for (i=0; i<500; i++) {
		for (j=0; j<16; j++)
			e_write_u32(dev, 0, 0, 0x2100 + 4*j, i*j);
		usleep(10000);
		for (j=0; j<16; j++) {
			uint32_t v = e_read_u32(dev, 0, 0, 0x2100 + 4*j);
			if (v != i*j) {
				sleep(1);
				uint32_t v2 = e_read_u32(dev, 0, 0, 0x2100 + 4*j);
				fprintf(stderr, "[w] Write failure %d,%d != %d @ 0x%4x\n", v, v2, i*j, 0x2100 + 4*j);
			}
		}
	}
}

int main(int argc, char *argv[])
{
        e_epiphany_t _epiphany, *epiphany = &_epiphany;
        int rv;

	e_init("/opt/adapteva/esdk/bsps/zed_E16G3_512mb/zed_E16G3_512mb.hdf");
	e_reset_system();

	e_set_host_verbosity(0);
	e_set_loader_verbosity(0);

        rv = e_open(epiphany, 0, 0, 1, 1);
        if (rv) {
                fprintf(stderr, "[!] Failed to open epiphany\n");
                return -1;
        }

	e_reset_core(epiphany, 0, 0);

	rv = e_load("../epiphany/main.srec", epiphany, 0, 0, e_true);
	if (rv == E_ERR) {
		fprintf(stderr, "[!] Error loading Epiphany program.\n");
		return -1;
	}

	e_write_u32(epiphany, 0, 0, 0x2004, 1);

	unsigned int r0 = e_read_u32(epiphany, 0, 0, 0x2000);
	do_write_tests(epiphany);
//	sleep(5);
	unsigned int r1 = e_read_u32(epiphany, 0, 0, 0x2000);

	e_write_u32(epiphany, 0, 0, 0x2004, 0);

	unsigned int r2;
	{
		int i;
		for (i=0; i<10; i++) {
 			r2 = e_read_u32(epiphany, 0, 0, 0x2000);
			if (!r2)
				break;
			printf(".");
			fflush(stdout);
			sleep(1);
			if (i>=5) {
				printf(" [%d:%d] ", r2, e_read_u32(epiphany, 0, 0, 0x2004));
				fflush(stdout);
				e_write_u32(epiphany, 0, 0, 0x2004, 0);
			}
		}
	}

	printf("%d - %d [%d]\n", r1 - r0, (int)roundf((600e6 * 5.0f) / (r1 - r0)), r2);

        e_close(epiphany);

        return 0;
}
