// file defs.h

#ifndef defs_H
#define defs_H

//  Common Includes (will be included in all projects)
#include <compiler_defs.h>
#include <C8051F912_defs.h>   // SFR declarations

//#define DEBUG

#define SYSCLK 12250000

__sfr __at (0xaa) _XPAGE;   // EMI0CN (SiLabs MCU) for SDCC compiler

#define TRUE 1
#define FALSE 0

#define OFF 0
#define ON 1

#define IN 0
#define OUT 1

#define LOW 0
#define HIGH 1
#define MRDY NSS1MD0

#define CLEAR 0
#define DISABLE 0
#define ENABLE 1
#define INT0 EX0

#define SECONDS 10  // state machine forever loop is approximately 100ms
#define MINUTES 60*SECONDS
#define HOURS   60*MINUTES



#endif