// file lpm.h

#ifndef LPM_H
#define LPM_H

#include "defs.h"

// power Management bit definitions
#define SLEEP        0x80   // sleep Mode Select
#define SUSPEND      0x40   // suspend Mode Select
#define WU_CLEAR     0x20   // wake-Up Flag Clear
#define PMATWK       0x02   // port Match Wake-Up
#define PORT_MATCH   PMATWK

// FLSCL bit definition
#define BYPASS    0x40
#define NON_ZERO  0x01

void LPM_Init(void);
void LPM_Enable_Wakeup(U8);
void LPM_Disable_Wakeup(U8);
void LPM(U8);

#endif
