#include "lpm.h"
#include "defs.h"

static void sysclkInit(void);

extern void pcm_init(void);
extern void pcmTMR3_isr(void);
extern void pcmSMB0_isr(void);

void timer3_isr(void) __interrupt INTERRUPT_TIMER3 { pcmTMR3_isr(); }
void smbus0_isr(void) __interrupt INTERRUPT_SMBUS0 { pcmSMB0_isr(); }

// required for SiLabs MCU
void _sdcc_external_startup(void) {
  PCA0MD &= ~0x40;  // WDTE = 0 (clear watchdog timer enable)
  PCA0MD = 0x00;
}

void main(void) {
  sysclkInit();
  pcm_init();
  LPM_Init();             // initialize power management

  for (;;)
    LPM(SLEEP);
}

//----------------------------------------------------------------------
// Routine Name : sysclkInit
// Input        : none
// Return       : none
// Description  : initializes the system clock 12.25MHz
//----------------------------------------------------------------------
static void sysclkInit(void) {
  FLSCL  = 0x40;
  OSCICN = 0x8F;
  CLKSEL = 0x10;
  OSCICL |= 0x80;
  RSTSRC = 0x06;
}
