
void deserializeInt(unsigned int *val, unsigned char *bufp, int *idx) {
  unsigned int value;
  int x = *idx;
  value = bufp[x++];
  value |= bufp[x++]<<8;
  value |= bufp[x++]<<16;
  value |= bufp[x++]<<24;
  *val = value; 
  *idx = x;
}

void deserializeIntArray(unsigned int *val, unsigned char *bufp, int *idx) {
  int nb;
  unsigned int value;
  int x = *idx;
  nb = bufp[x++];
  for (int i = 0; i < nb; i++) {
    value = bufp[x++];
    value |= bufp[x++]<<8;
    value |= bufp[x++]<<16;
    value |= bufp[x++]<<24;
    *val++ = value;
  }
  *idx = x;
}

void deserializeBool(char *val, unsigned char *bufp, int *idx) {
  int x = *idx;
  *val = bufp[x++];
  *idx = x;
}

void deserializeByte(unsigned char *val, unsigned char *bufp, int *idx) {
  int x = *idx;
  *val = bufp[x++];
  *idx = x;
}

void deserializeByteArray(unsigned char *val, unsigned char *bufp, int *idx) {
  int x = *idx;
  int nb = bufp[x++];
  for (int i = 0; i < nb; i++)
    *val++ = bufp[x++];
  *idx = x;
}

void deserializeFloat(float *val, unsigned char *bufp, int *idx) {
  unsigned char *p = (unsigned char *)val;
  int x = *idx;
  for (int j = 0; j < 4; j++)
    *p++ = bufp[x++];
  *idx = x;
}

void deserializeFloatArray(float *val, unsigned char *bufp, int *idx) {
  int nb, i, j;
  unsigned char *p = (unsigned char *)val;
  int x = *idx;
  nb = bufp[x++];
  for (i = 0; i < nb; i++)
    for (j = 0; j < 4; j++)
      *p++ = bufp[x++];
  *idx = x;
}

void deserializeString(unsigned char *val, unsigned char *bufp, int *idx) {
  int x = *idx;
  int nb = bufp[x++];
  for (int i = 0; i < nb; i++)
    *val++ = bufp[x++];
  *val++ = 0;
  *idx = x;
}

void deserializeStringArray(unsigned char *val, unsigned char *bufp, int *idx) {
  int x = *idx;
  int dim = bufp[x++];

  unsigned int *p = (unsigned int *)val;
  val += sizeof(int) + sizeof(unsigned char*) + (dim * sizeof(unsigned char*)); // points after size & p & array of pointers
  *p++ = dim;
  *p++ = (unsigned int)p;
  
  for (int i = 0; i < dim; i++) {
    *p++ = (unsigned int)val;
    int nb = bufp[x++];
    for (int j = 0; j < nb; j++)
      *val++ = bufp[x++];
    *val++ = 0;
  }
  *idx = x;
}
