/*
    FreeRTOS V8.1.2 - Copyright (C) 2014 Real Time Engineers Ltd. 
    All rights reserved

    VISIT http://www.FreeRTOS.org TO ENSURE YOU ARE USING THE LATEST VERSION.

    ***************************************************************************
     *                                                                       *
     *    FreeRTOS provides completely free yet professionally developed,    *
     *    robust, strictly quality controlled, supported, and cross          *
     *    platform software that has become a de facto standard.             *
     *                                                                       *
     *    Help yourself get started quickly and support the FreeRTOS         *
     *    project by purchasing a FreeRTOS tutorial book, reference          *
     *    manual, or both from: http://www.FreeRTOS.org/Documentation        *
     *                                                                       *
     *    Thank you!                                                         *
     *                                                                       *
    ***************************************************************************

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation >>!AND MODIFIED BY!<< the FreeRTOS exception.

    >>!   NOTE: The modification to the GPL is included to allow you to     !<<
    >>!   distribute a combined work that includes FreeRTOS without being   !<<
    >>!   obliged to provide the source code for proprietary components     !<<
    >>!   outside of the FreeRTOS kernel.                                   !<<

    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  Full license text is available from the following
    link: http://www.freertos.org/a00114.html

    1 tab == 4 spaces!

    ***************************************************************************
     *                                                                       *
     *    Having a problem?  Start by reading the FAQ "My application does   *
     *    not run, what could be wrong?"                                     *
     *                                                                       *
     *    http://www.FreeRTOS.org/FAQHelp.html                               *
     *                                                                       *
    ***************************************************************************

    http://www.FreeRTOS.org - Documentation, books, training, latest versions,
    license and Real Time Engineers Ltd. contact details.

    http://www.FreeRTOS.org/plus - A selection of FreeRTOS ecosystem products,
    including FreeRTOS+Trace - an indispensable productivity tool, a DOS
    compatible FAT file system, and our tiny thread aware UDP/IP stack.

    http://www.OpenRTOS.com - Real Time Engineers ltd license FreeRTOS to High
    Integrity Systems to sell under the OpenRTOS brand.  Low cost OpenRTOS
    licenses offer ticketed support, indemnification and middleware.

    http://www.SafeRTOS.com - High Integrity Systems also provide a safety
    engineered and independently SIL3 certified version for use in safety and
    mission critical applications that require provable dependability.

    1 tab == 4 spaces!
*/

// FreeRTOS includes
#include "FreeRTOS.h"
#include "Task.h"

// Xilinx includes
#include "defs.h"
#include "xparameters.h"
#include "scutimer.h"

#define XSCUTIMER_CLOCK_HZ ( XPAR_CPU_CORTEXA9_0_CPU_CLK_FREQ_HZ / 2UL )

// The application must provide a function that configures a peripheral to
// create the FreeRTOS tick interrupt, then define configSETUP_TICK_INTERRUPT()
// in FreeRTOSConfig.h to call the function.
//
// This function is called with the IRQ interrupt disabled, and the IRQ
// interrupt should be left disabled.  It is enabled automatically when the
// scheduler is started
void vConfigureTickInterrupt(void) {
  const uint8_t ucRisingEdge = 3;
  SCUTIMER_Type *scutimer = SCUTIMER_REG(SCUTIMER0);

  // The priority must be the lowest possible
  CPU_INTC_SetPriorityTriggerType(SCUTIMER_IRQ(SCUTIMER0), portLOWEST_USABLE_INTERRUPT_PRIORITY << portPRIORITY_SHIFT, ucRisingEdge );

  // Install the FreeRTOS tick handler
  CPU_INTC_ActivateInterrupt(SCUTIMER_IRQ(SCUTIMER0), SCUTIMER_ISR(SCUTIMER0), 0);

  // Initialise the timer
  scutimer->LOAD = XSCUTIMER_CLOCK_HZ / configTICK_RATE_HZ;
  scutimer->CONTROL = XSCUTIMER_CONTROL_AUTO_RELOAD_MASK | XSCUTIMER_CONTROL_ENABLE_MASK | XSCUTIMER_CONTROL_IRQ_ENABLE_MASK;

  // Enable the interrupt in the xTimer itself
  vClearTickInterrupt();
  CPU_INTC_InterruptEnable(SCUTIMER_IRQ(SCUTIMER0));
}
//-----------------------------------------------------------*/

void vClearTickInterrupt( void ) {
    SCUTIMER_REG(SCUTIMER0)->ISR = XSCUTIMER_ISR_EVENT_FLAG_MASK;
}
