
typedef void (*ISR_FN_t)(void);

typedef struct {
  int cmdId;
  unsigned char *bufp;
  unsigned int buflen;
  unsigned int chksum;
} CPU0Param;

typedef struct {
  int *p;
  int size;
} IntArray;

typedef struct {
  unsigned char *p;
  int size;
} ByteArray;

typedef struct {
  float *p;
  int size;
} FloatArray;

typedef struct {
  int size;
  unsigned char **p;
} StringArray;


#ifndef NULL
#define NULL		0
#endif 

#define TRUE 1
#define FALSE 0

#define RET_OK 0
#define RET_ERR 1

#define UINT8 unsigned char
#define UINT16 unsigned short
#define UINT32 unsigned int

typedef unsigned char BOOL;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef void (*HAL_CALLBACK_FPN)(void* arg);

#define global_interrupts_disable() __asm volatile("cpsid i")
#define global_interrupts_enable() __asm volatile("cpsie i") 

// prototypes
BOOL CPU_INTC_ActivateInterrupt(UINT32 Irq_Index, HAL_CALLBACK_FPN ISR, void* ISR_Param);
BOOL CPU_INTC_DeactivateInterrupt(UINT32 Irq_Index);
void CPU_INTC_Initialize(UINT32 CpuID);
BOOL CPU_INTC_InterruptEnable(UINT32 Irq_Index);
void CPU_INTC_SetPriorityTriggerType(UINT32 Int_Id, UINT8 Priority, UINT8 Trigger);


void deserializeInt(unsigned int *val, unsigned char *bufp, int *idx);
void deserializeBool(char *val, unsigned char *bufp, int *idx);
void deserializeByte(unsigned char *val, unsigned char *bufp, int *idx);
void deserializeFloat(float *val, unsigned char *bufp, int *idx);
void deserializeString(unsigned char *val, unsigned char *bufp, int *idx);
void deserializeByteArray(unsigned char *val, unsigned char *bufp, int *idx);
void deserializeIntArray(unsigned int *val, unsigned char *bufp, int *idx);
void deserializeFloatArray(float *val, unsigned char *bufp, int *idx);
void deserializeStringArray(unsigned char *val, unsigned char *bufp, int *idx);


