
typedef struct {
  unsigned int LOAD;     // Timer Load Register
  unsigned int COUNTER;  // Timer Counter Register
  unsigned int CONTROL;  // Timer Control Register
  unsigned int ISR;      // Timer Interrupt Status Register
} SCUTIMER_Type;

#define XSCUTIMER_CONTROL_PRESCALER_MASK   0x0000FF00 // Prescaler
#define XSCUTIMER_CONTROL_PRESCALER_SHIFT  8
#define XSCUTIMER_CONTROL_IRQ_ENABLE_MASK  0x00000004 // Intr enable
#define XSCUTIMER_CONTROL_AUTO_RELOAD_MASK 0x00000002 // Auto-reload
#define XSCUTIMER_CONTROL_ENABLE_MASK      0x00000001 // Timer enable

#define XSCUTIMER_ISR_EVENT_FLAG_MASK      0x00000001 // Event flag


#define TOTAL_SCUTIMER_PORT 1
#define SCUTIMER0 0

void FreeRTOS_Tick_Handler(void);

typedef void (*CALLBACK_FPN)(void* arg);

typedef struct {
  SCUTIMER_Type *reg;
  unsigned int irq;
  CALLBACK_FPN isr;
} SCUTIMER_PORT_T;

static SCUTIMER_PORT_T SCUTIMER_Port[TOTAL_SCUTIMER_PORT] = {
  { (SCUTIMER_Type *)XPAR_PS7_SCUTIMER_0_BASEADDR, XPAR_SCUTIMER_INTR, (CALLBACK_FPN)FreeRTOS_Tick_Handler }
};
#define SCUTIMER_REG(x)       (SCUTIMER_Port[x].reg)
#define SCUTIMER_IRQ(x)       (SCUTIMER_Port[x].irq)
#define SCUTIMER_ISR(x)       (SCUTIMER_Port[x].isr)


