#define __IO
#define __I

typedef struct {
       //UINT8 RESERVED_0[256];
  __IO UINT32 ICCICR;          // CPU Interface Control Register, offset: 0x100
  __IO UINT32 ICCPMR;          // Interrupt Priority Mask Register, offset: 0x104
  __IO UINT32 ICCBPR;          // Binary Point Register, offset: 0x108
  __IO UINT32 ICCIAR;          // Interrupt Acknowledge Register, offset: 0x10C
  __IO UINT32 ICCEOIR;         // End of Interrupt Register, offset: 0x110
  __IO UINT32 ICCRPR;          // Running Priority Register, offset: 0x114
  __IO UINT32 ICCHPIR;         // Highest Pending Interrupt Register, offset: 0x118
  __IO UINT32 ICCABPR;         // Aliased Binary Point Register, offset: 0x11C
       UINT8 RESERVED_1[3808];
  __IO UINT32 ICDDCR;          // Distributor Control Register, offset: 0x1000
       UINT32 ICDICTR;
       UINT32 ICDIIDR;
       UINT8 RESERVED_2[116];
  __IO UINT32 ICDISR[5];       // Interrupt Security Register 0..4, offset: 0x1080
       UINT8 RESERVED_3[108];
 __IO UINT32 ICDISER[5];       // Interrupt Set-Enable Register 0..4, offset: 0x1100
       UINT8 RESERVED_4[108];
  __IO UINT32 ICDICER[5];      // Interrupt Clear-Enable Register 0..4, offset: 0x1180
       UINT8 RESERVED_5[108];
  __IO UINT32 ICDISPR[5];      // Interrupt Set-Pending Register 0..4, offset: 0x1200
       UINT8 RESERVED_6[108];
  __IO UINT32 ICDICPR[5];      // Interrupt Security Register 0..4, offset: 0x1280
       UINT8 RESERVED_7[108];
  __IO UINT32 ICDABR[5];       // Active Bit Register 0..4, offset: 0x1300
       UINT8 RESERVED_8[236];
  __IO UINT32 ICDIPR[36];      // Interrupt Priority Register 0..35, offset: 0x1400
       UINT8 RESERVED_9[880];
  __IO UINT32 ICDIPTR[36];     // Interrupt Processor Targets Register 0..35, offset: 0x1800
       UINT8 RESERVED_10[880];
  __IO UINT32 ICDICFR[9];      // Interrupt Configuration Register 0..8, offset: 0x1C00
       UINT8 RESERVED_11[220];
  __I  UINT32 ICPPISR;         // Private Peripheral Interrupt Status Register, offset: 0x1D00
  __IO UINT32 ICSPISR[5];      // Shared Peripheral Interrupt Status Register 0..4, offset: 0x1D04
       UINT8 RESERVED_12[488];
  __IO UINT32 ICDSGIR;         // Software Generated Interrupt Register, offset: 0x1F00
} GIC_Type;

#define GIC ((volatile GIC_Type *)(XPAR_SCUGIC_0_CPU_BASEADDR))

// The maximum number of interrupts supported by the hardware
#define XSCUGIC_MAX_NUM_INTR_INPUTS    	95

#define XSCUGIC_INTR_PRIO_MASK	0xF8
#define XSCUGIC_PRIORITY_MASK	0x000000FF  // Each Byte corresponds to an INT_ID
#define XSCUGIC_INT_CFG_MASK    0x00000003

#define XSCUGIC_EN_INT_MASK	0x00000001 // Interrupt In Enable

BOOL CPU_INTC_ActivateInterrupt(UINT32 Irq_Index, HAL_CALLBACK_FPN ISR, void* ISR_Param);
BOOL CPU_INTC_DeactivateInterrupt(UINT32 Irq_Index);
void CPU_INTC_Initialize(UINT32 CpuID);
BOOL CPU_INTC_InterruptEnable(UINT32 Irq_Index);
void CPU_INTC_SetPriorityTriggerType(UINT32 Int_Id, UINT8 Priority, UINT8 Trigger);

