/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : blank.cpp
 * This copy created : Apr 13, 2015
 * Version           : 1.7
 * Description       : generate blank audio data class (source)
 ***************************************************************************/
#include <math.h>
#include "blank.h"

//----------------------------------------------------------------------
// Routine Name : Blank
// Input        : none
// Return       : none
// Description  : constructors
//----------------------------------------------------------------------
Blank::Blank() {
  Type(BLANK);
}
Blank::Blank(SourceTrack track, unsigned int totalSamples) {
  Type(BLANK);
  Track(track);
  TotalSamples(totalSamples);
}

//----------------------------------------------------------------------
// Routine Name : read
// Input        : bufp = buffer pointer where to read data
//                nSamples = number of samples to read
// Return       : number of data read
// Description  : generate and read a block of blank data
//----------------------------------------------------------------------
int Blank::read(float *bufp, unsigned int nSamples) {
  unsigned int count, i;
  float s;
  unsigned int totalSamples;
  unsigned int curSample;

  totalSamples = TotalSamples();
  curSample = CurSample();

  count = 0;
  if (Track() != MONO)
    nSamples /= 2; // stereo

  if (nSamples > totalSamples - curSample)
    nSamples = totalSamples - curSample;

  if (nSamples == 0)
    return(0);

  for (;;) {
    switch (Track()) {
      case MONO:
        *bufp++ = 0; 
        break;
      case STEREO_LEFT:
      case STEREO_RIGHT:
      case STEREO_BOTH:
        *bufp++ = 0; 
        *bufp++ = 0;
        break;
    }
    count++;
    if (count == nSamples) {
      curSample += count;
      if (Track() != MONO)
        count *= 2;

      CurSample(curSample);
      return(count);
    }
  }
}
