typedef struct {
  UINT32 CR;       // Control register
  UINT32 SR;       // Status register
  UINT32 CDESC;    // Current descriptor pointer
  UINT32 NA_1;
  UINT32 TDESC;    // Tail descriptor pointer
  UINT32 NA_2;
  UINT32 SRCADDR;  // Source address register
  UINT32 NA_3;
  UINT32 DSTADDR;  // Destination address register
  UINT32 NA_4;
  UINT32 BTT;      // Bytes to transfer
} CDMA_Type;

typedef struct {
  volatile CDMA_Type *reg;
  UINT32 irq;
  HAL_CALLBACK_FPN isr;
  BOOL SimpleNotDone;    // flag that a simple transfer is ongoing
} CDMA_PORT_T;

extern CDMA_PORT_T CDMA_Port[TOTAL_CDMA_PORT];

#define CDMA_REG(x)       (CDMA_Port[x].reg)
#define CDMA_IRQ(x)       (CDMA_Port[x].irq)
#define CDMA_ISR(x)       (CDMA_Port[x].isr)

#define CDMA_SimpleNotDone(x) (CDMA_Port[x].SimpleNotDone)

typedef struct {
  int id;
  UINT32 srcAddr;
  UINT32 destAddr;
  int len;
} CDMA_request;

#define XAXICDMA_CR_RESET_MASK		0x00000004 // Reset DMA engine
#define XAXICDMA_CR_SGMODE_MASK		0x00000008 // Scatter gather mode
#define XAXICDMA_CR_KHOLE_RD_MASK	0x00000010 // Keyhole Read
#define XAXICDMA_CR_KHOLE_WR_MASK	0x00000020 // Keyhole Write

#define XAXICDMA_SR_IDLE_MASK           0x00000002  // DMA channel idle
#define XAXICDMA_SR_SGINCLD_MASK        0x00000008  // Hybrid build
#define XAXICDMA_SR_ERR_INTERNAL_MASK   0x00000010  // Datamover internal err
#define XAXICDMA_SR_ERR_SLAVE_MASK      0x00000020  // Datamover slave err
#define XAXICDMA_SR_ERR_DECODE_MASK     0x00000040  // Datamover decode err
#define XAXICDMA_SR_ERR_SG_INT_MASK     0x00000100  // SG internal err
#define XAXICDMA_SR_ERR_SG_SLV_MASK     0x00000200  // SG slave err
#define XAXICDMA_SR_ERR_SG_DEC_MASK     0x00000400  // SG decode err
#define XAXICDMA_SR_ERR_ALL_MASK        0x00000770  // All errors

#define XAXICDMA_XR_IRQ_IOC_MASK	0x00001000 // Completion interrupt
#define XAXICDMA_XR_IRQ_DELAY_MASK	0x00002000 // Delay interrupt
#define XAXICDMA_XR_IRQ_ERROR_MASK	0x00004000 // Error interrupt
#define XAXICDMA_XR_IRQ_ALL_MASK	0x00007000 // All interrupts
#define XAXICDMA_XR_IRQ_SIMPLE_ALL_MASK	0x00005000 // All interrupts for simple only mode
#define XAXICDMA_XR_DELAY_MASK          0xFF000000 // Delay timeout counter
#define XAXICDMA_XR_COALESCE_MASK       0x00FF0000 // Coalesce counter

#define XAXICDMA_DELAY_SHIFT            24
#define XAXICDMA_COALESCE_SHIFT         16

#define XAXICDMA_DELAY_MAX              0xFF    // Maximum delay counter value
#define XAXICDMA_COALESCE_MAX           0xFF    // Maximum coalescing counter value

#define XAXICDMA_BD_NDESC_OFFSET        0x00 // Next descriptor pointer
#define XAXICDMA_BD_BUFSRC_OFFSET       0x08 // Buffer source address
#define XAXICDMA_BD_BUFDST_OFFSET       0x10 // Buffer destination address
#define XAXICDMA_BD_CTRL_LEN_OFFSET     0x18 // Control/buffer length
#define XAXICDMA_BD_STS_OFFSET          0x1C // Status
#define XAXICDMA_BD_PHYS_ADDR_OFFSET    0x20 // Physical address of the BD
#define XAXICDMA_BD_ISLITE_OFFSET       0x24 // Lite mode hardware build?
#define XAXICDMA_BD_HASDRE_OFFSET       0x28 // Support unaligned transfers?
#define XAXICDMA_BD_WORDLEN_OFFSET      0x2C // Word length in bytes
#define XAXICDMA_BD_MAX_LEN_OFFSET      0x30 // Word length in bytes

#define XAXICDMA_BD_START_CLEAR         8   // Offset to start clear
#define XAXICDMA_BD_TO_CLEAR            24  // BD specific bytes to be cleared
#define XAXICDMA_BD_NUM_WORDS           16  // Total number of words for one BD*/
#define XAXICDMA_BD_HW_NUM_BYTES        32  // Number of bytes hw used

#define XAXICDMA_BD_CTRL_LENGTH_MASK    0x007FFFFF // Requested len

#define XAXICDMA_BD_STS_COMPLETE_MASK   0x80000000 // Completed
#define XAXICDMA_BD_STS_DEC_ERR_MASK    0x40000000 // Decode error
#define XAXICDMA_BD_STS_SLV_ERR_MASK    0x20000000 // Slave error
#define XAXICDMA_BD_STS_INT_ERR_MASK    0x10000000 // Internal err
#define XAXICDMA_BD_STS_ALL_ERR_MASK    0x70000000 // All errors
#define XAXICDMA_BD_STS_ALL_MASK        0xF0000000 // All status bits

#define XAXICDMA_MAX_TRANSFER_LEN	0x7FFFFF  // Max length hw supports

#define XAXICDMA_RESET_LOOP_LIMIT	5

int CDMA_init(int cdmNum);
void CDMA_transfer(int id, UINT32 srcAddr, UINT32 dstAddr, int length, int isISR);
