/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : cdp.cpp
 * This copy created : May 16, 2015
 * Version           : 1.2
 * Description       : cd player class (source)
 *                     spdif_in cd data is written into BUF_RECORD (FIFO1 ISR)
 *                     then read from there and spdif_out
 ***************************************************************************/
#include "defs.h"
#include "cdp.h"

extern short *recordBuf;  // updated by FIFO1 ISR (spdif_in)

//----------------------------------------------------------------------
// Routine Name : Cdp
// Input        : none
// Return       : none
// Description  : initialization defaults (constructor)
//----------------------------------------------------------------------
Cdp::Cdp() {
  out_p = (short *)BUF_RECORD;
  lastrecordBuf = (short *)BUF_RECORD;
}

//----------------------------------------------------------------------
// Routine Name : read
// Input        : bufp = destination pointer
//                nsamples = number of samples to read
// Return       : number of samples read
// Description  : reads a number of samples from BUF_RECORD
//                note: read will never return 0 (=end)
//----------------------------------------------------------------------
int Cdp::read(float *bufp, unsigned int nsamples) {

  if (recordBuf > lastrecordBuf)
    lastrecordBuf = recordBuf;

  if (lastrecordBuf >= out_p + nsamples) {
    for (int i = 0; i < nsamples; i++)
      *bufp++ = *out_p++ * (1.0f / 32768.0f);
    lastrecordBuf += nsamples;
    if (out_p - (short *)BUF_RECORD >= BUF_RECORD_SIZE) {  // circular buffer
      out_p = (short *)BUF_RECORD;
      lastrecordBuf = recordBuf;
    }
  }
  else {  // if no data yet, fill with blanks
    for (int i = 0; i < nsamples; i++)
      *bufp++ = 0.0;
  }
  return(nsamples);
}
