struct c_complex {
  double re, im;
};

struct complex {
  double re, im;
  complex(double r, double i = 0.0) { re = r; im = i; }
  complex() { }					/* uninitialized complex */
  complex(c_complex z) { re = z.re; im = z.im; }	/* init from denotation */
};

complex csqrt(complex);
complex cexp(complex);
complex expj(double);
complex evaluate(complex[], int, complex[], int, complex);

inline double hypot(complex z) { return ::hypot(z.im, z.re); }
inline double atan2(complex z) { return ::atan2(z.im, z.re); }

inline complex operator * (double a, complex z) {
  z.re *= a; z.im *= a;
  return z;
}

inline complex operator / (complex z, double a) {
  z.re /= a; z.im /= a;
  return z;
}

complex operator * (complex z1, complex z2) {
  return complex(z1.re*z2.re - z1.im*z2.im, z1.re*z2.im + z1.im*z2.re);
}

complex operator / (complex z1, complex z2) {
  double mag = (z2.re * z2.re) + (z2.im * z2.im);

  return complex(((z1.re * z2.re) + (z1.im * z2.im)) / mag, ((z1.im * z2.re) - (z1.re * z2.im)) / mag);
}

inline complex operator + (complex z1, complex z2) {
  z1.re += z2.re;
  z1.im += z2.im;
  return z1;
}

inline complex operator - (complex z1, complex z2) {
  z1.re -= z2.re;
  z1.im -= z2.im;
  return z1;
}

inline complex operator - (complex z) { return 0.0 - z; }

inline complex sqr(complex z) { return z*z; }


/* evaluate polynomial in z, substituting for z */
complex eval(complex coeffs[], int npz, complex z) { 
  complex sum = complex(0.0);

  for (int i = npz; i >= 0; i--) 
    sum = (sum * z) + coeffs[i];
  return sum;
}

/* evaluate response, substituting for z */
complex evaluate(complex topco[], int nz, complex botco[], int np, complex z) { 
  return eval(topco, nz, z) / eval(botco, np, z);
}

// because of deficiencies in hypot on Sparc, it's possible 
// for arg of Xsqrt to be small and -ve,
// which logically it can't be (since r >= |x.re|).	 Take it as 0
double Xsqrt(double x) {
  return (x >= 0.0) ? sqrt(x) : 0.0;
}

complex csqrt(complex x) {
  double r = hypot(x);

  complex z = complex(Xsqrt(0.5 * (r + x.re)), Xsqrt(0.5 * (r - x.re)));
  if (x.im < 0.0) z.im = -z.im;
    return z;
}

complex cexp(complex z) {
  return exp(z.re) * expj(z.im);
}

complex expj(double theta) {
  return complex(cos(theta), sin(theta));
}
