// cpu0/cpu1 locks
// ---------------
#ifndef _CPU_LOCKS_H_
#define _CPU_LOCKS_H_ 1

#define LOCK_BASEADDR 0xFFFFC000
#define TOTAL_SGI_PORT 4

typedef struct {
  UINT32 lock;  // transmitter clears lock and receiver sets lock
  UINT32 arg1;
  UINT32 arg2;
  UINT32 arg3;
} LOCK_Type;

typedef struct {
  volatile LOCK_Type *reg;
  UINT32 irq;
  HAL_CALLBACK_FPN isr;
} SGI_PORT_T;

#define SGI_REG(x)       (SGI_Port[x].reg)
#define SGI_IRQ(x)       (SGI_Port[x].irq)
#define SGI_ISR(x)       (SGI_Port[x].isr)

#define INTC_SGI1_ID 1  // functionSlave parameters cpu0 to cpu1
#define LOCK1 0

#define INTC_SGI2_ID 2  // functionSlave return cpu1 to cpu0
#define LOCK2 1

#define INTC_SGI3_ID 3  // interruptSlave cpu1 to cpu0
#define LOCK3 2

#define INTC_SGI4_ID 4  // cpu0 request SD read access
#define LOCK4 3

#define TO_CPU0 1  // generate SGI to CPU#
#define TO_CPU1 2

extern void SGI2_IRQHandler(void* param);
extern void SGI3_IRQHandler(void* param);

extern SGI_PORT_T  SGI_Port[TOTAL_SGI_PORT];


#endif // _CPU_LOCKS_H_
