#ifndef DEFS_H
#define DEFS_H

#include <stdint.h>

typedef struct {
  int cmdId;
  unsigned char *bufp;
  unsigned int buflen;
  unsigned int chksum;
} CPU0Param;

typedef struct {
  int *p;
  int size;
} IntArray;

typedef struct {
  unsigned char *p;
  int size;
} ByteArray;

typedef struct {
  float *p;
  int size;
} FloatArray;

typedef struct {
  int size;
  unsigned char **p;
} StringArray;

#ifndef NULL
#define NULL		0
#endif 

#define TRUE 1
#define FALSE 0

#define RET_OK 0
#define RET_ERR -1

#define GPIO_PIN_NONE 0
#define TOTAL_USART_PORT 1

#define TOTAL_FIFO_PORT 2
#define FIFO0 0
#define FIFO1 1

#define TOTAL_SD_PORT 1
#define SD0 0

#define TOTAL_CDMA_PORT 1
#define CDMA0 0

#define TOTAL_I2C_PORT 1
#define I2C0 0

#define APU_FREQ  666666687
#define SYSTEM_CLOCK_KHZ 666666
#define NETMF_TICKS_PER_SECOND 2000000  // 2 NETMF tick per us


#define SAMPLES_PER_FRAME   2       // CD stereo
#define FRAMES_PER_BLOCK    64
#define NUM_BLOCKS          1024
#define NB_FRAMES           NUM_BLOCKS * FRAMES_PER_BLOCK

#define SAMPLING_RATE 44100 

#define SINEWAVE_FP_FREQ    11025
#define NB_SINEWAVES        10

#define LOGSWEEP_SAMPLES    2*1024*1024

#define NB_SET 8
#define FPL  0
#define FPR  1
#define LPL  2
#define LPR  3
#define BPL  4
#define BPR  5
#define HPL  6
#define HPR  7

//------------------------------------------------------------------------------------------

// audio output buffers, format = short, size = NB_FRAMES*NB_CHAN*sizeof(short) = 524288
#define BUF_OUT0 0x02000000
#define BUF_OUT1 0x02080000
#define BUF_OUT 0x02100000

// audio output buffer, format = float, size = NB_FRAMES*SAMPLES_PER_FRAME*sizeof(float) = 524288
#define BUF_FLOAT 0x02180000

// xover buffer, size = NB_FRAMES*NB_CHAN*sizeof(float) = 1048576
#define BUF_FLOATXO 0x02200000

// short_to_float conversion (wavefile.cpp)
#define BUF_CONV 0x02300000

// convolver buffers (max. 2*1024*1024 points), size = (LOGSWEEP_SAMPLES = 2*1024*1024*sizeof(float) = 0x800000) samples*4 = 0x2000000
#define BUF_TEMP 0x10000000
#define BUF_SIGNAL 0x12000000
#define BUF_CONVSIGNAL 0x14000000
#define BUF_LO 0x16000000

// calibrate buffer, size = 0x800000
#define BUF_CALIB 0x1a000000

// audio input buffer
#define BUF_RECORD 0x30000000
#define BUF_RECORD_SIZE 0x800000

//------------------------------------------------------------------------------------------

#define LEFT_TRACK        0       // index
#define RIGHT_TRACK       1

typedef enum SourceType { 
  WAVEFILE  = 0,
  LOGSWEEP = 1,
  INVLOGSWEEP = 2,
  SINEWAVE = 3,
  LOGSWEEP_SIN = 4, // 10 sinewave prefix
  BLANK = 5,
  TRIGGER = 7,
  CDPLAYER = 8
} SourceType;

typedef enum WaveFormat { 
  PCM  = 1,
  FLOAT = 3
} WaveFormat;

typedef enum FileMode { 
  FILE_READ  = 1,
  FILE_WRITE = 2
} FileMode;

typedef enum SourceTrack {
  MONO = 0,
  STEREO_LEFT = 1,
  STEREO_RIGHT = 2,
  STEREO_BOTH = 3
} SourceTrack;

//------------------------------------------------------------------------------------------
typedef signed   long long int64_t;
typedef unsigned long long uint64_t;
typedef int32_t intptr_t;
typedef uint32_t uintptr_t; 

#define UINT8 uint8_t
#define UINT16 uint16_t
#define INT32 int32_t
#define UINT32 uint32_t
#define INT64 int64_t
#define UINT64 uint64_t

typedef unsigned char BOOL;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef uint32 GPIO_PIN;
typedef void (*ISR_FN_t)(void);
typedef void (*HAL_CALLBACK_FPN)(void* arg);

#define global_interrupts_disable() __asm volatile("cpsid i")
#define global_interrupts_enable() __asm volatile("cpsie i") 


#endif /* DEFS_H */