//-----------------------------------------------------------------------------
//
//                   ** WARNING! ** 
//    This file was generated automatically by a tool.
//    Re-running the tool will overwrite this file.
//    You should copy this file to a custom location
//    before adding any customization in the copy to
//    prevent loss of your changes when the tool is
//    re-run.
//
//-----------------------------------------------------------------------------

#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>

#include "stdlib.h"
#include "defs.h"
#include "deserialize.h"

#include "D:\MicroFrameworkPK_v4_3\DeviceCode\Targets\Native\Zynq7000\DeviceCode\cpu_locks.h"

extern void functionCompletion(int cmdId, int retval);
extern int initPlayer();

//-----------------------------------------------------------
void dispatcherTask(void *pvParameters);
extern xQueueHandle dispatcherQueue;
extern CPU0Param dispatcherParam;

#define NUM_FUNCTION_MESSAGES    30

#define ToCpu1_TASK_PRIORITY   (tskIDLE_PRIORITY+1)
static void ToCpu1Task(void *pvParameters);
static xQueueHandle ToCpu1Queue;

extern void ToCpu1_setIrq(int fposUpdateIrq);
extern void ToCpu1_cdCommand(unsigned char cmd, char *name, int fpos);

//-----------------------------------------------------------
void dispatcherTask(void *pvParameters) {
  volatile LOCK_Type *lock;

  ToCpu1Queue = xQueueCreate(NUM_FUNCTION_MESSAGES, sizeof(CPU0Param));
  xTaskCreate(ToCpu1Task, (signed char *)"ToCpu1", 1024, NULL, ToCpu1_TASK_PRIORITY, NULL);

  lock = SGI_REG(LOCK1);
  lock->lock = 1;  // lock ready for transmitter

  lock = SGI_REG(LOCK4); 
  lock->lock = 1; // TODO: should be done by cpu0

  for (;;) {
    if (xQueueReceive(dispatcherQueue, &dispatcherParam, portMAX_DELAY)) {
      switch (dispatcherParam.cmdId) {
      case 0x9965:  // ToCpu1_setIrq
      case 0xBA0D:  // ToCpu1_cdCommand
        xQueueSend(ToCpu1Queue, &dispatcherParam, 0);
        break;
      }
    }
  }
}

//-----------------------------------------------------------
static void ToCpu1Task(void *pvParameters) {
  int cmdId, buflen;
  unsigned char *bufp;
  CPU0Param ToCpu1Param;

  initPlayer();
  for( ;; ) {
    xQueueReceive(ToCpu1Queue, &ToCpu1Param, portMAX_DELAY);
    cmdId = dispatcherParam.cmdId;
    bufp = dispatcherParam.bufp;
    int idx = 0;

    switch (dispatcherParam.cmdId) {
    case 0x9965:  // ToCpu1_setIrq
      {
        int retsetIrq = 0;
        int fposUpdateIrq;
        deserializeInt(&fposUpdateIrq, bufp, &idx);

        ToCpu1_setIrq(fposUpdateIrq);
        functionCompletion(cmdId, (unsigned int)retsetIrq);
      }
      break;

    case 0xBA0D:  // ToCpu1_cdCommand
      {
        int retcdCommand = 0;
        unsigned char cmd;
        deserializeByte(&cmd, bufp, &idx);

        char *name = pvPortMalloc(bufp[idx]+1);
        deserializeString(name, bufp, &idx);

        int fpos;
        deserializeInt(&fpos, bufp, &idx);

        ToCpu1_cdCommand(cmd, name, fpos);
        vPortFree(name);
        functionCompletion(cmdId, (unsigned int)retcdCommand);
      }
      break;
    }
  }
}
