
#define BRAM_IN_DEPTH 4096
#define BRAM_OUT__DEPTH 8192
#define BRAM_WIDTH 64

typedef struct {
  uint32 ISR;       // Interrupt Status Register
  uint32 IER;       // Interrupt Enable Register
  uint32 TDFR;      // Transmit Data FIFO Reset
  uint32 TDFV;      // Transmit Data FIFO Vacancy
  uint32 TDFD;      // Transmit Data FIFO 32-bit Wide Data Write Port
  uint32 TLF;       // Transmit Length Register
  uint32 RDFR;      // Receive Data FIFO Reset
  uint32 RDFO;      // Receive Data FIFO Occupancy
  uint32 RDFD;      // Receive Data FIFO 32-bit Wide Data Read Port
  uint32 RLF;       // Receive Length Register
  uint32 LLR;       // AXI4-Stream Reset
  uint32 TDR;       // Transmit Destination Register
  uint32 RDR;       // Receive Destination Register
  uint32 TIDR;      // Transmit ID Register
  uint32 TUR;       // Transmit USER Register
  uint32 RIDR;      // Receive ID Register
  uint32 RUR;       // Receive USER Register
} FIFO_Type;

typedef struct {
  volatile FIFO_Type *reg;
  uint32 irq;
  HAL_CALLBACK_FPN isr;
} FIFO_PORT_T;

extern FIFO_PORT_T FIFO_Port[TOTAL_FIFO_PORT];

#define FIFO_REG(x)       (FIFO_Port[x].reg)
#define FIFO_IRQ(x)       (FIFO_Port[x].irq)
#define FIFO_ISR(x)       (FIFO_Port[x].isr)


// Interrupt bits 
// These bits are associated with the XLLF_IER_OFFSET and XLLF_ISR_OFFSET registers.
#define XLLF_INT_RPURE_MASK       0x80000000 // Receive under-read 
#define XLLF_INT_RPORE_MASK       0x40000000 // Receive over-read 
#define XLLF_INT_RPUE_MASK        0x20000000 // Receive underrun (empty) 
#define XLLF_INT_TPOE_MASK        0x10000000 // Transmit overrun 
#define XLLF_INT_TC_MASK          0x08000000 // Transmit complete 
#define XLLF_INT_RC_MASK          0x04000000 // Receive complete 
#define XLLF_INT_TSE_MASK         0x02000000 // Transmit length mismatch 
#define XLLF_INT_TRC_MASK         0x01000000 // Transmit reset complete 
#define XLLF_INT_RRC_MASK         0x00800000 // Receive reset complete 
#define XLLF_INT_TFPF_MASK        0x00400000 // Tx FIFO Programmable Full AXI FIFO MM2S Only 
#define XLLF_INT_TFPE_MASK        0x00200000 // Tx FIFO Programmable Empty AXI FIFO MM2S Only 
#define XLLF_INT_RFPF_MASK        0x00100000 // Rx FIFO Programmable Full AXI FIFO MM2S Only 
#define XLLF_INT_RFPE_MASK        0x00080000 // Rx FIFO Programmable Empty AXI FIFO MM2S Only 
#define XLLF_INT_ALL_MASK         0xfff80000 // All the ints 
#define XLLF_INT_ERROR_MASK       0xf2000000 // Error status ints 
#define XLLF_INT_RXERROR_MASK     0xe0000000 // Receive Error status ints 
#define XLLF_INT_TXERROR_MASK     0x12000000 // Transmit Error status ints 

// Reset register values
// These bits are associated with the XLLF_TDFR_OFFSET and XLLF_RDFR_OFFSET reset registers.
#define XLLF_RDFR_RESET_MASK      0x000000a5 // receive reset value
#define XLLF_TDFR_RESET_MASK      0x000000a5 // Transmit reset value
#define XLLF_LLR_RESET_MASK       0x000000a5 // Local Link reset value

int FifoInit(int fifoNum);
