//-----------------------------------------------------------------------------
//
//                   ** WARNING! ** 
//    This file was generated automatically by a tool.
//    Re-running the tool will overwrite this file.
//    You should copy this file to a custom location
//    before adding any customization in the copy to
//    prevent loss of your changes when the tool is
//    re-run.
//
//-----------------------------------------------------------------------------
//#include <__cross_studio_io.h>
#include <math.h>
#include <string.h>

#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>

#include "defs.h"
#include "Zynq7000_intc.h"
#include "fifo.h"
#include "cdma.h"
#include "convolver.h"
#include "xover.h"
#include "fatfs.h"
#include "play.h"

#include "cpu_locks.h"

static FATFS fs[2];  // FatFs work area needed for each volume
static FIL Fil;      // File object needed for each open file

PARTITION VolToPart[] = {
  {0, 1},    // Logical drive 0 ==> Physical drive 0, 1st partition 
  {0, 2},    // Logical drive 1 ==> Physical drive 0, 2nd partition
  {1, 0}     // Logical drive 2 ==> Physical drive 1, auto detection
};

// global variables
int activeBufout;  // switch between bufout0 and bufout1
short *blankBuf = (short *)BUF_OUT;
short *shortBufout0 = (short *)BUF_OUT0;
short *shortBufout1 = (short *)BUF_OUT1;
short *recordBuf;  // record buffer spdif_in

SemaphoreHandle_t flippedSemaphore;
int exitPlay;

// local variables
static float *floatBuf = (float *)BUF_FLOAT;
static float *floatBufXO = (float *)BUF_FLOATXO;

static float convolverAdjust;
static float level[NB_SET]; // volume applied to each relevant sample (in dB)

// delays
#define MAX_DELAY 20  // in millisecond
#define DELAY_BUFSIZE  ((SAMPLING_RATE * MAX_DELAY)/1000)*2
static float delayBuf0[DELAY_BUFSIZE], delayBuf1[DELAY_BUFSIZE];
static unsigned int delayMax;  // highest set delay
static unsigned int delay[NB_SET]; // values returned during calibration
static unsigned int delayIndex[NB_SET];  // current index position

// crossovers bi-amp/tri-amp
static int cutoff1 = 0;
static int filterOrder1 = 2;  // default 12dB/octave
static int cutoff2 = 0;
static int filterOrder2 = 2;  // default 12dB/octaveS

static unsigned int nbChan = SAMPLES_PER_FRAME; // number of output channels (default = 2)

#define PLAY_TASK_PRIORITY   (tskIDLE_PRIORITY+1)
static xQueueHandle playerQueue;

static int curFpos;
static SemaphoreHandle_t playerDoneSemaphore;
static int fposUpdateIrqnum;

// function prototypes
static void playerTask(void *pvParameters);
static int player();

static void paramsInit();
static void initLevel();
static void initDelay();
static void clearBuffers();
static void xover(float *src, float *dest, int nb_chan, int nb_frames);
static void copyDelayBuf(float *src, float *dest, unsigned int len, unsigned int bufSize);
static float getDelayedValue(int idx);
static void float_to_short(float *src, short *dest, int nSamples);

void interruptSlave(int irqId, int data1, int data2);

//----------------------------------------------------------------------
// Routine Name : copyDelayBuf
// Input        : src = audio data source pointer
//                dest = delay buffer destination pointer
//                len = max size
//                bufSize = audio data buffer size
// Return       : none
// Description  : copy data chunck corresponding to the delay shift (from end of data buffer)
//----------------------------------------------------------------------
static void copyDelayBuf(float *src, float *dest, unsigned int len, unsigned int bufSize) {
  float *inbufp;

  if (len != 0) {
    if (bufSize > len) {
      inbufp = src + (bufSize - len);
      for (int i = 0; i < len; i++)
        *dest++ = *inbufp++;
    }
    else
      for (int i = 0; i < len; i++)
        *dest++ = 0;
  }
}

//----------------------------------------------------------------------
// Routine Name : getDelayedValue
// Input        : idx = index of data
// Return       : sample value
// Description  : get the next audio sample (from delay buffer or normal buffer)
//----------------------------------------------------------------------
static float getDelayedValue(int idx) {
  float *inbufp;

  if (delayIndex[idx] < delayMax)
    inbufp = (activeBufout == 0 ? delayBuf0 : delayBuf1) + delayIndex[idx];
  else
    inbufp = floatBuf + (delayIndex[idx]-delayMax);
  
  if (idx % 2 != 0)
    inbufp++; // right channel
  delayIndex[idx] += 2;

  return(*inbufp);
}

//----------------------------------------------------------------------
// Routine Name : float_to_short
// Input        : src = normalized audio data source pointer
//                dest = 16bit audio data destination pointer
//                nSamples = number of samples to convert
// Return       : none
// Description  : convert buffer of float to short
//----------------------------------------------------------------------
static void float_to_short(float *src, short *dest, int nSamples) {
  for (int i = 0; i < nSamples; i++) {
    short samp = (short) (*src * (32767.0f));
    *dest = samp;
    src++;
    dest++;
  }
}

//----------------------------------------------------------------------
// Routine Name : initLevel
// Input        : none
// Return       : none
// Description  : volume levels initialization
//----------------------------------------------------------------------
static void initLevel() {
  int volume, balanceVal, balanceLeft, balanceRight;
  int lev[NB_SET];
 
  volume = 0;
  balanceVal = 0;
  lev[FPL] = lev[FPR] = lev[LPL] = lev[LPR] = lev[BPL] = lev[BPR] = lev[HPL] = lev[HPR] = 0;
  balanceLeft = (balanceVal < 0 ? balanceVal: 0);
  balanceRight = (balanceVal > 0 ? -balanceVal: 0);

  for (int i = 0; i < NB_SET; i += 2) {
    level[i] = (float)pow(10.0, (float)(volume + balanceLeft + lev[i]) / 20.0);
    level[i+1] = (float)pow(10.0, (float)(volume + balanceRight + lev[i+1]) / 20.0);
  }
}

//----------------------------------------------------------------------
// Routine Name : initDelay
// Input        : none
// Return       : none
// Description  : speaker delays initialization
//----------------------------------------------------------------------
static void initDelay() {
  // values set during calibration (sound generation + travel time)
   delay[FPL] = 0;
  delay[FPR] = 0;
  delay[LPL] = 212;
  delay[LPR] = 215;
  delay[BPL] = 0;
  delay[BPR] = 0;
  delay[HPL] = 0;
  delay[HPR] = 0;

  // stereo signal so we need to copy 2 times the number of samples to buffer
  for (int i = 0; i < NB_SET; i++)
    delay[i] *= 2;

  // find the highest value
  delayMax = 0;
  for (int i = 0; i < NB_SET; i++)
    if (delayMax < delay[i])
      delayMax = delay[i];
}

//----------------------------------------------------------------------
// Routine Name : paramsInit
// Input        : none
// Return       : none
// Description  : general parameters initialization
//----------------------------------------------------------------------
static void paramsInit() {
  exitPlay = 0;
  activeBufout = 0;
  //convolverAdjust: 300 + (x * 10) i.e.: -4.2dB -> 258.0 (0dB -> 300.0)
  convolverAdjust = (float)pow(10.0, ((float)260.8 - (float)300.0) / 200.0);  // -3.92dB Tact

  // Tact setup 
  // bass = LP: 200 Hz Altec 515 bass drivers
  // HP: 200Hz with respective crossovers set in Tact-2150 amps for YL compression drivers with horns:
  // . low-medium = LP: 1200Hz (i.e. 200-1200)
  // . medium = BP: 1200Hz-8000Hz
  // . trebble = HP: 8000Hz (i.e.8000-22000)
  cutoff1 = 200;
  cutoff2 = 0;
  filterOrder1 = 4;
  filterOrder2 = 0;

  if (cutoff1)
    nbChan += 2;
  if (cutoff2)
    nbChan += 2;
	
  initLevel();
  initDelay();
}

//----------------------------------------------------------------------
// Routine Name : clearBuffers
// Input        : none
// Return       : none
// Description  : clear all residual data
//----------------------------------------------------------------------
static void clearBuffers() {

  // clear the 2 FPGA bram blocks
  //CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_0_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);
  //CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_1_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);

  // clear playback buffers
  for (int i = 0; i < NB_FRAMES*nbChan; i++) {
    shortBufout0[i] = 0;
    shortBufout1[i] = 0;
  }
  // clear delay buffers
  for (int i = 0; i < DELAY_BUFSIZE; i++) {
    delayBuf0[i] = 0;
    delayBuf1[i] = 0;
  }
  // clear convolver buffers
  convolverInit(NB_FRAMES);

  xoverClear();
}

//----------------------------------------------------------------------
// Routine Name : xover
// Input        : src = audio data source pointer
//                dest = audio data destination pointer
//                nb_chan = number of crossovers
//                nSamples = number of stereo samples  
// Return       : none
// Description  : apply crossover to buffer
//----------------------------------------------------------------------
static void xover(float *src, float *dest, int nb_chan, int nb_frames) {
  float sampleLeft, sampleRight;

  for (int i = 0; i < nb_frames; i++) {
    sampleLeft = *src++;
    sampleRight = *src++;

    if (nb_chan == 2) {
      if (delay[FPL] != 0)
        sampleLeft = getDelayedValue(FPL);
      if (delay[FPR] != 0)
        sampleRight = getDelayedValue(FPR);
  
      *dest++ = sampleLeft * level[FPL];
      *dest++ = sampleRight * level[FPR];
    }
    if (nb_chan >= 4) {
      if (delay[HPL] != 0)
        sampleLeft = getDelayedValue(HPL);
      if (delay[HPR] != 0)
        sampleRight = getDelayedValue(HPR);
#ifdef DENON
      *dest++ = sampleLeft * level[HPL];
      *dest++ = sampleRight * level[HPR];
#else
      *dest++ = highpass(LEFT_TRACK, sampleLeft) * level[HPL];
      *dest++ = highpass(RIGHT_TRACK, sampleRight) * level[HPR];
#endif
    }
    if (nb_chan >= 6) {
      if (delay[BPL] != 0)
        sampleLeft = getDelayedValue(BPL);
      if (delay[BPR] != 0)
        sampleRight = getDelayedValue(BPR);
#ifdef DENON
      *dest++ = sampleLeft * level[BPL];
      *dest++ = sampleRight * level[BPR];
#else
      *dest++ = bandpass(LEFT_TRACK, sampleLeft) * level[BPL];
      *dest++ = bandpass(RIGHT_TRACK, sampleRight) * level[BPR];
#endif
    }
    if (nb_chan > 2) {
      if (delay[LPL] != 0)
        sampleLeft = getDelayedValue(LPL);
      if (delay[LPR] != 0)
        sampleRight = getDelayedValue(LPR);
#ifdef DENON
      *dest++ = sampleLeft * level[LPL];
      *dest++ = sampleRight * level[LPR];
#else
      *dest++ = lowpass(LEFT_TRACK, sampleLeft) * level[LPL];
      *dest++ = lowpass(RIGHT_TRACK, sampleRight) * level[LPR];
#endif
    }
  }
}

//----------------------------------------------------------------------
// Routine Name : initPlayer()
// Input        : none
// Return       : none
// Description  : playback initialization
//----------------------------------------------------------------------
int initPlayer() {
  volatile LOCK_Type *lock;
  int err;

  for (;;) {
    err = RET_ERR;
    // set the ISL9305 for the Parallella
    //extern int isl9305_init(void);
    //isl9305_init();
    
    paramsInit();
    
    //CPU_INTC_ActivateInterrupt(SD_IRQ(SD0), SD_ISR(SD0), 0);

    if (CDMA_init(CDMA0) != RET_OK)
      break;

    if (FifoInit(FIFO0) != RET_OK)
      break;

    if (FifoInit(FIFO1) != RET_OK)
      break;

    if (xoverInit(SAMPLING_RATE, cutoff1, cutoff2, filterOrder1, filterOrder2) != RET_OK)
      break;

    for (int i = 0; i < NB_FRAMES*nbChan; i++)
      blankBuf[i] = 0;
    clearBuffers();

    if (f_mount(&fs[0], "0:", 0) != RET_OK)
      break;

    if (f_mount(&fs[1], "1:", 0) != RET_OK)
      break;

    // get convolver ready
    convolverInit(NB_FRAMES);
    convolverScaleCoef2(convolverAdjust);
    if (convolverImpulse(WAVEFILE, "drc.wav") != RET_OK)
      break;

    if ((flippedSemaphore = xSemaphoreCreateBinary()) == NULL)
      break;

    if ((playerDoneSemaphore = xSemaphoreCreateBinary()) == NULL)
      break;

    xSemaphoreGive(playerDoneSemaphore);

    playerQueue = xQueueCreate(4, 1);
    xTaskCreate(playerTask, (signed char *)"player", configMINIMAL_STACK_SIZE, NULL, PLAY_TASK_PRIORITY, NULL);

    err = RET_OK;
    break;  // exit the forever loop
  }
  return err;
}

//----------------------------------------------------------------------
// Routine Name : player
// Input        : none
// Return       : status code
// Description  : playback loop
//----------------------------------------------------------------------
static int player() {
  UINT sRead;
  short *shortBuf;

  // play loop
  int firstLoop = TRUE;
  activeBufout = 0;
  int done = FALSE;
  int fpos = -1;
  for (;;) {
    // cdma writes from shortBufout0 when activeBufout = 0
    // -> when activeBufout = 0 then copy SD to shortBufout1
    shortBuf = activeBufout == 0 ? shortBufout1 : shortBufout0;

    if (curFpos == fpos) {
      interruptSlave(fposUpdateIrqnum, curFpos, 0);  // tell Netmf app the current position
    }
    else { // fwd or bwd occurred
      if (firstLoop == FALSE) {
        // clear the 2 FPGA bram blocks
        CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_0_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);
        CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_1_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);
      }
      clearBuffers();
      play_setMute(FALSE);
    }
    if ((sRead = play_read(floatBuf, NB_FRAMES * SAMPLES_PER_FRAME)) == 0)
      done = TRUE;
    else {
      curFpos += sRead;
      fpos = curFpos;
#ifndef DENON
      convolve(floatBuf);  // apply the room correction (DRC)
#endif
      // copy delay data chunk into opposite delay buffer (i.e. accessed first after next flip)
      copyDelayBuf(floatBuf, activeBufout == 0 ? delayBuf1 : delayBuf0, delayMax, NB_FRAMES*SAMPLES_PER_FRAME);
      for (int i = 0; i < NB_SET; i++)
        delayIndex[i] = delayMax - delay[i];

      xover(floatBuf, floatBufXO, nbChan, NB_FRAMES);
      float_to_short(floatBufXO, (short *)shortBuf, NB_FRAMES*nbChan);  // convert back to pcm format
     
      if (firstLoop == TRUE) {
        firstLoop = FALSE;
        FIFO_REG(FIFO0)->IER |= XLLF_INT_ALL_MASK;
        FIFO_REG(FIFO1)->IER |= XLLF_INT_ALL_MASK;
      }
    }
    for (;;) {
      if (xSemaphoreTake(flippedSemaphore, 100) == pdTRUE)
        break;
      if (exitPlay == TRUE)
        break;
    }
    if (done == TRUE || exitPlay == TRUE)
      break;
  }
  play_setMute(TRUE);
  // clear the 2 FPGA bram blocks
  CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_0_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);
  CDMA_transfer(1, (UINT32)blankBuf, XPAR_BRAM_1_BASEADDR, BRAM_OUT__DEPTH*(BRAM_WIDTH/8), FALSE);
  clearBuffers();
 
  xSemaphoreGive(playerDoneSemaphore);

  return RET_OK;
}

// ---------------------------------------------------------------------------
static void playerTask(void *pvParameters) {
  uint8 cmd;

  for (;;) {
    xQueueReceive(playerQueue, &cmd, portMAX_DELAY);
    exitPlay = FALSE;
    player();
  }
}

// ---------------------------------------------------------------------------
void ToCpu1_setIrq(int fposUpdateIrq) {
  fposUpdateIrqnum = fposUpdateIrq;
}

// ---------------------------------------------------------------------------
int ToCpu1_cdCommand(unsigned char cmd, char *name, int fpos) {
  int err;
  volatile FIFO_Type *fifo = FIFO_REG(FIFO0);

  err = RET_ERR;
  for (;;) {
    if (name[0] != 0) {
      // new file to play
      play_setMute(TRUE);
      exitPlay = TRUE;  // stop play session
      xSemaphoreTake(playerDoneSemaphore, portMAX_DELAY);  // wait for player loop to exit
      play_close();
      if (play_open(WAVEFILE, name) != RET_OK)
        break;
      curFpos = fpos;
      play_seek(fpos);
      xQueueSend(playerQueue, &cmd, 0);  // tell playerTask to start the player loop
      play_setPause(FALSE);
    }
    else {
      switch (fpos) {
      case 0:
        // pause
        play_setMute(TRUE);
        vTaskDelay(500);
        play_setPause(TRUE);
        break;

      case -1:
        // resume play (after pause)
        play_setPause(FALSE);  // play
        play_setMute(FALSE);
        break;

      default:
        curFpos = fpos;
        play_setMute(TRUE);
        play_seek(fpos);
        break;
      }
    }
    err = RET_OK;
    break;  // exit the forever loop
  }
  return err;
}

