
typedef struct {
  UINT32 CR;         // 32-bit Control
  UINT32 SR;         // Status
  UINT32 ADDR;       // I2C Address
  UINT32 DATA;       // I2C FIFO Data
  UINT32 ISR;        // Interrupt Status
  UINT32 TRANS_SIZE; // Transfer Size
  UINT32 SLV_PAUSE;  // Slave monitor pause
  UINT32 TIME_OUT;   // Time Out
  UINT32 IMR;        // Interrupt Enabled Mask
  UINT32 IER;        // Interrupt Enable
  UINT32 IDR;        // Interrupt Disable 
} I2C_Type;

typedef struct {
  volatile I2C_Type *reg;
  UINT32 irq;
  HAL_CALLBACK_FPN isr;
} I2C_PORT_T;

extern I2C_PORT_T I2C_Port[TOTAL_I2C_PORT];

#define I2C_REG(x)  (I2C_Port[x].reg)
#define I2C_IRQ(x)  (I2C_Port[x].irq)
#define I2C_ISR(x)  (I2C_Port[x].isr)

#define I2C_FIFO_DEPTH        16          // Number of bytes in the FIFO

#define I2C_IXR_ALL_INTR_MASK 0x000002FF  // All ISR Mask
#define I2C_IXR_COMP_MASK     0x00000001  // Transfer Complete Interrupt mask
#define I2C_IXR_NACK_MASK     0x00000004  // NACK Interrupt mask
#define I2C_IXR_RX_OVR_MASK   0x00000020  // Receive Overflow Interrupt mask
#define I2C_IXR_TX_OVR_MASK   0x00000040  // Transmit Overflow Interrupt mask
#define I2C_IXR_RX_UNF_MASK   0x00000080  // FIFO Receive Underflow Interrupt mask
#define I2C_IXR_ARB_LOST_MASK 0x00000200  // Arbitration Lost Interrupt mask

#define I2C_DATA_INTR_DEPTH   14          // Number of bytes at DATA intr
#define I2C_TO_RESET_VALUE    0x0000001F  // I2C Time Out reset value

#define I2C_SR_RXDV_MASK      0x00000020  // Receiver Data Valid Mask
#define I2C_SR_TXDV_MASK      0x00000040  // Transmit Data Valid Mask
#define I2C_SR_BA_MASK        0x00000100  // Bus Active Mask

#define I2C_CR_RESET_VALUE    0           // Reset value of the Control register
#define I2C_CR_RD_WR_MASK     0x00000001  // Read or Write Master, transfer  0=Transmitter, 1=Receiver
#define I2C_CR_MS_MASK        0x00000002  // Master mode bit 1=Master, 0=Slave
#define I2C_CR_NEA_MASK       0x00000004  // Addressing Mode 1=7 bit, 0=10 bit
#define I2C_CR_ACKEN_MASK     0x00000008  // Enable TX of ACK when Master receiver
#define I2C_CR_HOLD_MASK      0x00000010  // Hold bus 1=Hold scl, 0=terminate transfer
#define I2C_CR_CLR_FIFO_MASK  0x00000040  // Clear FIFO, auto clears
#define I2C_CR_DIV_A_MASK     0x0000C000  // Clock Divisor A
#define I2C_CR_DIV_B_MASK     0x00003F00  // Clock Divisor B
#define I2C_CR_DIV_A_SHIFT    14          // Clock Divisor A shift
#define I2C_CR_DIV_B_SHIFT    8           // Clock Divisor B shift

int i2c_init();
int i2c_write(UINT16 addr, UINT8 *bufp, int len);
int i2c_read(UINT16 addr, UINT8 *bufp, int len);
