#include "defs.h"
#include "i2c.h"
 
#define ISL9305_ADDR  0x68

//-----------------------------------------------------------
int isl9305_init(void) {
  int err;
  UINT8 buf[16];
  volatile I2C_Type *i2c = I2C_REG(I2C0);

  for (int i = 0; i < 16; i++)
    buf[i] = 0;

  for (;;) {
    err = RET_ERR;

    if (i2c_init() != RET_OK)
      break;

    buf[0] = 0x05;  // SYS_PARAMETER
    buf[1] = 0x10;  // disable selection
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    // Epiphany
    buf[0] = 0x00;  // DCD1 address
    buf[1] = 0x07;  // 1.0V
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    // DDR3L
    buf[0] = 0x01;  // DCD2 address
    buf[1] = 0x15;  // 1.35V
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    // PEC_POWER VDD_ADJ
    buf[0] = 0x02;  // LDO1 address
    buf[1] = 0x30;  // 3.3V
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    // VDD_GPIO
    buf[0] = 0x03;  // LDO2 address
    buf[1] = 0x28;  // 2.9V
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    buf[0] = 0x05;  // SYS_PARAMETER
    buf[1] = 0x1f;  // enable selection
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;
    buf[0] = 0x05;  // SYS_PARAMETER
    buf[1] = 0x6f;  // enable selection
    if (i2c_write(ISL9305_ADDR, buf, 2) != RET_OK)
      break;

    // read settings back
    buf[0] = 0x00;
    if (i2c_write(ISL9305_ADDR, buf, 1) != RET_OK)
      break;
   if (i2c_read(ISL9305_ADDR, buf, 7) != RET_OK)
      break;

    err = RET_OK;
    break;  // exit the forever loop
  }
  return err;
}
