#ifndef LOGSWEEP_H
#define LOGSWEEP_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "source.h"

#define LOW_FREQ 10.0
#define HIGH_FREQ 21000.0

class Logsweep: public Source {
public:
  Logsweep();
  Logsweep(SourceTrack track, int lowFrequency, int highFrequency, unsigned int totalSamples);
  void Inverse(bool inverse);
  void LowFrequency(float frequency);
  void HighFrequency(float frequency);
  int read(float *bufp, unsigned int nSamples);
  unsigned long seek();

private:
  float lowFrequency;
  float highFrequency;

  bool initialized;
  bool inverse;
  double magnitude;

  double om;
  double N;
  double Noct;
};

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* LOGSWEEP_H */

