/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : measure.cpp
 * This copy created : Apr 14, 2015
 * Version           : 1.6
 * Description       : generates and returns the measurement data
 *                     (classes array set in play.cpp)
 ***************************************************************************/
#include <vector>

#include "measure.h"

// The C++ library calls the function abort on errors such as being unable 
// to allocate memory when calling the new operator.
// This function is not included in the C++ library allowing you to handle
// the error in your application as you see fit, you therefore need to 
// implement this function yourself in your application.
extern "C" void abort(void) {
  while (1);
}

std::vector<Source *> &Measure::getVector() { return mVector; }

Measure::Measure(SourceType type) { Type(type); }
Measure::~Measure() { 
  for (std::vector<Source*>::iterator i = mVector.begin(); i != mVector.end(); ++i)
    delete *i;
}

//----------------------------------------------------------------------
// Routine Name : Track
// Input        : track = selected left or right track
// Return       : none
// Description  : set the track of every segment
//----------------------------------------------------------------------
void Measure::Track(SourceTrack track) {
  Source::Track(track);
  for (std::vector<Source*>::iterator i = mVector.begin(); i != mVector.end(); ++i)
    (*i)->Track(track);
}

//----------------------------------------------------------------------
// Routine Name : read
// Input        : bufp = buffer pointer where to put the read data
//                nSamples = number of samples to read
// Return       : number of samples read
// Description  : read samples of classes array one after another
//----------------------------------------------------------------------
int Measure::read(float *bufp, unsigned int nSamples) {
  unsigned int total, count;

  total = 0;
  for (std::vector<Source*>::iterator i = mVector.begin(); i != mVector.end(); ++i) {
    if ((count = (*i)->read(bufp, nSamples)) == nSamples)
      return(total+count);

    bufp += count;
    nSamples -= count;
    total += count;
  }
  return(total);
}
