/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : sinewave.cpp
 * This copy created : Apr 27, 2015
 * Version           : 1.10
 * Description       : generate sinewave audio data class (source)
 ***************************************************************************/
#include <math.h>
#include "defs.h"
#include "sinewave.h"

#define PI     3.14159265358979323846

//----------------------------------------------------------------------
// Routine Name : Sinewave
// Input        : none
// Return       : none
// Description  : initialization defaults (constructors)
//----------------------------------------------------------------------
Sinewave::Sinewave() {
  Type(SINEWAVE);
  frequency = SINEWAVE_FP_FREQ;
  nSamplesPeriod = (unsigned int)(SamplingRate()/frequency); 
  offset = 0;
  magnitude = 1.0;
}
Sinewave::Sinewave(SourceTrack track, int frequency, int nPeriods) {
  Type(SINEWAVE);
  Track(track);
  this->nPeriods = nPeriods;
  this->frequency = frequency;
  nSamplesPeriod = (unsigned int)(SamplingRate()/frequency);
  TotalSamples((unsigned int)((SamplingRate()/frequency)*nPeriods));
  offset = 0;
  magnitude = 1.0;
}
//----------------------------------------------------------------------
void Sinewave::Frequency(float frequency) {
  this->frequency = frequency;
  nSamplesPeriod = (unsigned int)(SamplingRate()/frequency); // per period
}
float Sinewave::Frequency() {
  return frequency;
}

//----------------------------------------------------------------------
// Routine Name : read
// Input        : bufp = buffer pointer where to read data
//                nSamples = number of samples to read
// Return       : number of data read
// Description  : generate and read a block of sinewave data
//----------------------------------------------------------------------
int Sinewave::read(float *bufp, unsigned int nSamples) {
  unsigned int count, i;
  float s;
  unsigned int totalSamples;
  unsigned int curSample;

  totalSamples = TotalSamples();
  curSample = CurSample();

  count = 0;
  if (Track() != MONO)
    nSamples /= 2; // stereo

  if (nSamples > totalSamples - curSample)
    nSamples = totalSamples - curSample;

  if (nSamples == 0)
    return(0);

  for (;;) {
    for(i = offset; i < nSamplesPeriod; i++) {
      s = 0;
      if (nSamplesPeriod != totalSamples)
        s = (float)(magnitude * (sin(2.0 * PI * i / nSamplesPeriod)));

      switch (Track()) {
        case MONO:
          *bufp++ = (float)s; 
          break;
        case STEREO_LEFT:
          *bufp++ = (float)s; 
          *bufp++ = 0;
          break;
        case STEREO_RIGHT:
          *bufp++ = 0;        
          *bufp++ = (float)s;
          break;
        case STEREO_BOTH:
          *bufp++ = (float)s;
          *bufp++ = (float)s;
          break;
      }
      count++;
      if (count == nSamples) {
        offset = i;
        curSample += count;
        if (Track() != MONO)
          count *= 2;

        CurSample(curSample);
        return(count);
      }
    }
  }
}
