#ifndef SINEWAVE_H
#define SINEWAVE_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "source.h"

class Sinewave: public Source {
public:
  Sinewave();
  Sinewave(SourceTrack track, int frequency, int nPeriods);
  void Frequency(float frequency);
  float Frequency();
  int read(float *bufp, unsigned int nsamples);

private:
  double magnitude;
  unsigned int nSamplesPeriod;   // number of samples per period
  int offset;                    // where the previous period was left
  float frequency;
  int nPeriods;
};

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SINEWAVE_H */

