/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : source.cpp
 * This copy created : Apr 14, 2015
 * Version           : 1.7
 * Description       : source base class
 ***************************************************************************/
#include "defs.h"
#include "source.h"

Source::Source() {
  track = STEREO_BOTH;
  samplingRate = SAMPLING_RATE;
  totalSamples = 0;
  curSample = 0;
}

Source::~Source() { }

void Source::Type(SourceType type) { this->type = type; }
SourceType Source::Type() { return(type); }

SourceTrack Source::Track() { return track; }

int Source::SamplingRate() { return samplingRate; }

void Source::TotalSamples(unsigned int totalSamples) { this->totalSamples = totalSamples; }
unsigned int Source::TotalSamples() { return totalSamples; }

void Source::CurSample(unsigned int curSample) { this->curSample = curSample; }
unsigned int Source::CurSample() { return curSample; }

unsigned long Source::Pos() { return pos; }

// virtual functions
void Source::Track(SourceTrack track) { this->track = track; }

void Source::Inverse(bool inverse) { }

void Source::Frequency(float frequency) { }
float Source::Frequency() { return 0; }

void Source::LowFrequency(float frequency) { }
float Source::LowFrequency() { return 0; }
void Source::HighFrequency(float frequency) { }
float Source::HighFrequency() { return 0; }
void Source::Pos(unsigned long pos) { this->pos = pos; }

int Source::open(char *filename, FileMode mode) { return 0; }
int Source::read(unsigned char *bufp, unsigned int nbytes) { return 0; }
int Source::read(float *bufp, unsigned int nsamples) { return 0; }
unsigned long Source::seek() { return 0; }

