#ifndef SOURCE_H
#define SOURCE_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "defs.h"

class Source {
public:
  Source();
  virtual ~Source();
  void Type(SourceType type);
  SourceType Type();
  SourceTrack Track();
  int SamplingRate();
  void TotalSamples(unsigned int totalSamples);
  unsigned int TotalSamples();
  void CurSample(unsigned int curSample);
  unsigned int CurSample();
  unsigned long Pos();

  virtual void Track(SourceTrack track);
  virtual void Inverse(bool inverse);
  virtual void Frequency(float frequency);
  virtual float Frequency();
  virtual void LowFrequency(float frequency);
  virtual float LowFrequency();
  virtual void HighFrequency(float frequency);
  virtual float HighFrequency();
  virtual void Pos(unsigned long pos);

  virtual int open(char *filename, FileMode mode);
  virtual int read(unsigned char *bufp, unsigned int nbytes);
  virtual int read(float *bufp, unsigned int nsamples);
  virtual unsigned long seek();

private:
  SourceType type;
  SourceTrack track;
  int samplingRate;
  unsigned int totalSamples;
  unsigned int curSample;
  unsigned long pos;
};

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SOURCE_H */

