/****************************************************************************
 * sd1player - Audio playback
 *
 * File              : trigger.cpp
 * This copy created : Apr 26, 2015
 * Version           : 1.5
 * Description       : generate trigger audio data class (source)
 *                     . if pol = true arm_trigger should be after a Blank class
 *                       only because the trigger will be activated on the first 
 *                       non-zero spdif_out audio data after arming 
 *                     . if pol = false arm_trigger should be before a Blank class
 *                       because the trigger will be activated on the first
 *                       3 zero spdif_out audio data after arming 
 *                     also make sure there are at least 2 times shortBufout
 *                     size between 2 trigger arming          
 ***************************************************************************/
#include <math.h>
#include "trigger.h"
#include "play.h"

//----------------------------------------------------------------------
// Routine Name : Trigger
// Input        : none
// Return       : none
// Description  : constructors
//----------------------------------------------------------------------
Trigger::Trigger() {
  Type(TRIGGER);
  TotalSamples(1);
}
Trigger::Trigger(SourceTrack track, bool pol) {
  Type(TRIGGER);
  Track(track);
  TotalSamples(1);
  this->pol = pol;
}

//----------------------------------------------------------------------
// Routine Name : read
// Input        : bufp = buffer pointer where to read data
//                nSamples = number of samples to read
// Return       : number of data read
// Description  : generate and read trigger data
//----------------------------------------------------------------------
int Trigger::read(float *bufp, unsigned int nSamples) {
  unsigned int curSample;

  curSample = CurSample();
  SourceTrack track = Track();

  if (track != MONO)
    nSamples /= 2; // stereo

  if (nSamples > 1 - curSample)
    nSamples = 1 - curSample;

  if (nSamples == 0)
    return(0);

  // anything not zero (then 0xa55a is what we'll get back from spdif_in)
  switch (track) {
  case MONO:
    *bufp++ = 0xa5a5 * (1.0f / 32767.0f);
     break;
  case STEREO_LEFT:
  case STEREO_RIGHT:
  case STEREO_BOTH:
    *bufp++ = 0xa5a5 * (1.0f / 32767.0f);
    *bufp++ = 0xa5a5 * (1.0f / 32767.0f);
    break;
  }
  curSample++;
  CurSample(curSample);

  // warning: there is a lag between the time trigger is set and when the sample is effectively outputted to spdif
  play_setTriggerTrack(track == STEREO_LEFT ? LEFT_TRACK : RIGHT_TRACK);  // spdif channelA in fpga
  play_setTriggerPol(pol);

  play_setTrigger(FALSE);  // reset FPGA trigger
  play_setTrigger(TRUE);  // arm FPGA trigger

  return(track == MONO ? 1 : 2);
}
