#ifndef WAVEFILE_H
#define WAVEFILE_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "source.h"
#include "fatfs.h"

class Wavefile: public Source {
public:
  Wavefile();
  ~Wavefile();

  int open(char *filename, FileMode mode);
  int read(unsigned char *bufp, unsigned int nbytes); 
  int read(float *bufp, unsigned int nsamples);
  int write(short *bufp, unsigned int nsamples);
  int write(float *bufp, unsigned int nsamples);
  void Pos(unsigned long);
  unsigned long seek();

private:
  WaveFormat format;  // pcm or float
  SourceTrack track;
  FIL file;  
};

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* WAVEFILE_H */

