
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_unsigned.all;

entity spdif_thru is
  Port(
    clk : IN STD_LOGIC;
    spdif_rx : IN STD_LOGIC;
    active : in std_logic;
    mono : in std_logic;
    trigger : in std_logic;
    Flip : OUT std_logic_vector(7 downto 0); 
    BRAM0_addr : OUT std_logic_vector(31 downto 0);
    BRAM0_data : OUT std_logic_vector(63 downto 0);
    BRAM0_we : OUT std_logic_vector(7 downto 0);
    BRAM1_addr : OUT std_logic_vector(31 downto 0);
    BRAM1_data : OUT std_logic_vector(63 downto 0);
    BRAM1_we : OUT std_logic_vector(7 downto 0)
  );
end spdif_thru;

architecture Behavioral of spdif_thru is
  COMPONENT spdif_in
  PORT(
    clk : IN std_logic;
    spdif_in : IN std_logic;          
    sampleNow : IN std_logic;          
    transition : OUT std_logic;
    subframe : OUT std_logic_vector(27 downto 0);
    startOfFrame : OUT std_logic;
    channelA : OUT std_logic;
    newSubframe : OUT std_logic
  );
  END COMPONENT;

  COMPONENT clock_recovery
  PORT(
    clk : IN std_logic;
    transition : IN std_logic;          
    sampleNow : OUT std_logic
  );
  END COMPONENT;

  signal sampleNow : std_logic;
  signal inputTransition : std_logic;
    
  signal inputSubframe : std_logic_vector(27 downto 0);
  signal inputStartOfFrame : std_logic;
  signal inputChannelA : std_logic;
  signal inputNewSubframe : std_logic;
 
  signal addr : std_logic_vector(16 downto 0) := (others => '0');
  signal adrsel : STD_LOGIC_VECTOR(1 downto 0) := (others => '0');
  signal datasample : std_logic_vector(15 downto 0) := (others => '0');
  
  signal we0 : std_logic_vector(7 downto 0) := (others => '0');
  signal we1 : std_logic_vector(7 downto 0) := (others => '0');
  
  signal triggered : std_logic := '1';
  
begin
BRAM0_addr <= "00000000000000000" & addr(14 downto 0);
BRAM1_addr <= "00000000000000000" & addr(14 downto 0); 
--Flip <= "111" & addr(15) & "0000";

BRAM0_we <= we0;
BRAM1_we <= we1;
  
process(clk)
begin
  if clk'event and clk = '1' then
    if trigger = '1' then
      triggered <= '0';
      datasample <= x"a55a"; 
    else
      if triggered = '0' then
        if inputNewSubframe = '1' and inputChannelA = '1' then
          triggered <= '1';
        end if;  
      else
        datasample <= inputSubframe(23 downto 8);
      end if;
    end if;
  end if;
end process;

process(clk)
begin
  if clk'event and clk = '0' then
    if active = '1' then
      Flip <= "111" & addr(15) & "0000";
    else
      Flip <= "0000" & "0000";
    end if;
  end if;
end process; 

process(clk)
begin
  if clk'event and clk = '0' then
    if inputNewSubframe = '1' then
      if mono = '0' or inputChannelA = mono then
        if adrsel = "00" then
          addr <= addr+8;
        end if;
      end if;
    end if;
  end if;
end process;

process(clk)
variable chanA : std_logic;
variable chanB : std_logic;
begin
  if clk'event and clk = '1' then
    if inputNewSubframe = '1' then
      if mono = '1' then
        chanA := inputChannelA;  -- only channelA sample
        chanB := '0';
      else
        if inputChannelA = '1' and adrsel(0) = '0' then
          chanA := '1';
        else
          chanA := '0';
        end if;
        if inputChannelA = '0' and adrsel(0) = '1' then
          chanB := '1';
        else
          chanB := '0';
        end if;
      end if;
      
      if chanA = '1' or chanB = '1' then
        case adrsel is
        when "00" => 
          if addr(15) = '0' then 
            BRAM0_data <= x"000000000000" & datasample;
            we0 <= "00000011";
          else
            BRAM1_data <= x"000000000000" & datasample;
            we1 <= "00000011";
          end if;
        when "01" =>
          if addr(15) = '0' then 
            BRAM0_data <=  x"00000000" & datasample & x"0000";
            we0 <= "00001100";
          else
            BRAM1_data <=  x"00000000" & datasample & x"0000";
            we1 <= "00001100";
          end if;
        when "10" =>
          if addr(15) = '0' then 
            BRAM0_data <=  x"0000" & datasample & x"00000000";
            we0 <= "00110000";
          else
            BRAM1_data <=  x"0000" & datasample & x"00000000";
            we1 <= "00110000";
          end if;
        when "11" =>
          if addr(15) = '0' then 
            BRAM0_data <=  datasample & x"000000000000";
            we0 <= "11000000";
          else
            BRAM1_data <=  datasample & x"000000000000";
            we1 <= "11000000";
          end if;
        end case;
        adrsel <= adrsel+1;
      end if;
    else
      we0 <= "00000000";
      we1 <= "00000000";
    end if;
  end if;
end process;
  
spdif_input: spdif_in PORT MAP(
  clk => clk,
  spdif_in => spdif_rx,
  sampleNow => sampleNow,
  transition => inputTransition,
  subframe => inputSubframe,
  startOfFrame => inputStartOfFrame,
  channelA => inputChannelA,
  newSubframe => inputNewSubframe
);

recover_clock: clock_recovery PORT MAP(
  clk => clk,
  transition => inputTransition,
  sampleNow => sampleNow
);

end Behavioral;
