
`timescale 1 ns / 1 ps

	module flipFifoIP_v1_0_M00_AXIS #
	(
		// Users to add parameters here
		// User parameters ends
		// Do not modify the parameters beyond this line

		// Width of S_AXIS address bus. The slave accepts the read and write addresses of width C_M_AXIS_TDATA_WIDTH.
		parameter integer C_M_AXIS_TDATA_WIDTH	= 32,
		// Start count is the numeber of clock cycles the master will wait before initiating/issuing any transaction.
		parameter integer C_M_START_COUNT	= 32
	)
	(
		// Users to add ports here
        input wire [7:0] Flip,
		// User ports ends
		// Do not modify the ports beyond this line

		// Global ports
		input wire  M_AXIS_ACLK,
		// 
		input wire  M_AXIS_ARESETN,
		// Master Stream Ports. TVALID indicates that the master is driving a valid transfer, A transfer takes place when both TVALID and TREADY are asserted. 
		output wire  M_AXIS_TVALID,
		// TDATA is the primary payload that is used to provide the data that is passing across the interface from the master.
		output wire [C_M_AXIS_TDATA_WIDTH-1 : 0] M_AXIS_TDATA,
		// TSTRB is the byte qualifier that indicates whether the content of the associated byte of TDATA is processed as a data byte or a position byte.
		output wire [(C_M_AXIS_TDATA_WIDTH/8)-1 : 0] M_AXIS_TSTRB,
		// TLAST indicates the boundary of a packet.
		output wire  M_AXIS_TLAST,
		// TREADY indicates that the slave can accept a transfer in the current cycle.
		input wire  M_AXIS_TREADY
	);
    reg [C_M_AXIS_TDATA_WIDTH-1 : 0] flipValue;
    reg [7:0] lastFlip;
    reg transmitted;
    assign M_AXIS_TDATA = flipValue;
    assign M_AXIS_TSTRB = {(C_M_AXIS_TDATA_WIDTH/8){1'b1}};
        
    always @(posedge M_AXIS_ACLK)
      if (!M_AXIS_ARESETN) begin
         flipValue <= 0;
         transmitted <= 0;
      end
      else begin
        transmitted <= 0;
        if (M_AXIS_TVALID && M_AXIS_TREADY) begin
          flipValue[7:0] = Flip[7:0];
          transmitted <= 1;
        end
      end
      
    reg EnR;
    reg [7:0] afterResetCycleCounterR;
      
    always @(posedge M_AXIS_ACLK)
      if (!M_AXIS_ARESETN) begin
        EnR <= 0;
        afterResetCycleCounterR <= 0;
      end
      else begin
        afterResetCycleCounterR <= afterResetCycleCounterR + 1;
        if (afterResetCycleCounterR == C_M_START_COUNT)
          EnR <= 1;
      end
         
    reg tValidR;
    assign M_AXIS_TVALID = tValidR;
    assign M_AXIS_TLAST = tValidR;
      
    always @(posedge M_AXIS_ACLK) begin
      if (!M_AXIS_ARESETN || !EnR) begin
        tValidR <= 0;
        lastFlip <= 0;
      end
      else begin
        if (tValidR == 0 && lastFlip != Flip) begin
          lastFlip = Flip;
          tValidR <= 1;
        end
        else begin
          if (transmitted) begin
            tValidR <= 0;
          end
        end
      end
    end // always @ (posedge M_AXI

endmodule
