library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity spdif_transmitter is
  port(
    sys_clk : IN std_logic;  -- FCLK
    spdif_clk : IN std_logic; -- 128x Fsample
    reset : IN std_logic;
    trigger_arm : IN std_logic;
    trigger_pol : IN std_logic;
    trigger_chan : IN std_logic;
    trigger : OUT std_logic;
    Flip : OUT std_logic_vector(7 downto 0); 
    BRAM0_addr : OUT std_logic_vector(31 downto 0);
    BRAM0_data : IN std_logic_vector(31 downto 0);
    BRAM1_addr : OUT std_logic_vector(31 downto 0);
    BRAM1_data : IN std_logic_vector(31 downto 0);
    pause : IN std_logic;
    mute : IN std_logic;
    to_fir : OUT std_logic_vector(31 downto 0)
  );
end entity spdif_transmitter;

architecture behavioral of spdif_transmitter is
  COMPONENT spdif_data PORT(
    spdif_clk : IN std_logic; -- 128x Fsample
    reset : IN std_logic;
    trigger_arm : IN std_logic;
    trigger_pol : IN std_logic;
    trigger_chan : IN std_logic;
    trigger : OUT std_logic;
    pause : IN std_logic;
    mute : IN std_logic;
    BRAM0_addr : OUT std_logic_vector(31 downto 0);
    BRAM0_data : IN std_logic_vector(31 downto 0);
    BRAM1_addr : OUT std_logic_vector(31 downto 0);
    BRAM1_data : IN std_logic_vector(31 downto 0);
    stereo_sample : OUT std_logic_vector(31 downto 0);
    Flip : OUT std_logic_vector(7 downto 0)
  );
  END COMPONENT;
 
  signal stereo_sample_s : std_logic_vector(31 downto 0);
  
begin
  to_fir <= stereo_sample_s;
  
  spdif_dat: spdif_data PORT MAP(
    spdif_clk => spdif_clk,
    reset => reset,
    trigger_arm => trigger_arm,
    trigger_pol => trigger_pol,
    trigger_chan => trigger_chan,
    trigger => trigger,
    pause => pause,
    mute => mute,
    BRAM0_addr => BRAM0_addr,
    BRAM0_data => BRAM0_data,
    BRAM1_addr => BRAM1_addr,
    BRAM1_data => BRAM1_data,
    stereo_sample => stereo_sample_s,
    Flip => Flip
  );

end behavioral;
