--Copyright 1986-2015 Xilinx, Inc. All Rights Reserved.
----------------------------------------------------------------------------------
--Tool Version: Vivado v.2015.2 (win64) Build 1266856 Fri Jun 26 16:35:25 MDT 2015
--Date        : Fri Jul 10 12:00:07 2015
--Host        : pat-PC running 64-bit Service Pack 1  (build 7601)
--Command     : generate_target lp200_spdif_wrapper.bd
--Design      : lp200_spdif_wrapper
--Purpose     : IP block netlist
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;


entity lp200_spdif_wrapper is
  generic (
    C_DELAY_LEFT : std_logic_vector(9 downto 0) := "0000000000";
    C_DELAY_RIGHT : std_logic_vector(9 downto 0) := "0000000000"
  );
  port (
    --addra : in STD_LOGIC_VECTOR ( 10 downto 0 );
    --dina : in STD_LOGIC_VECTOR ( 15 downto 0 );
    --douta : out STD_LOGIC_VECTOR ( 15 downto 0 );
    --from_fir_left : out STD_LOGIC_VECTOR ( 15 downto 0 );
    --from_fir_right : out STD_LOGIC_VECTOR ( 15 downto 0 );
    --from_fir_valid : out STD_LOGIC;
    sys_clk : in STD_LOGIC;
    to_fir : in STD_LOGIC_VECTOR ( 31 downto 0 );
    --to_fir_valid : in STD_LOGIC;
    --wea : in STD_LOGIC_VECTOR ( 0 to 0 )
    reset : in STD_LOGIC;
    spdif_clk : in STD_LOGIC;
    spdif : out STD_LOGIC 
  );
end lp200_spdif_wrapper;

architecture STRUCTURE of lp200_spdif_wrapper is
  component lp200_spdif is
  port (
    from_fir_left : out STD_LOGIC_VECTOR ( 15 downto 0 );
    sys_clk : in STD_LOGIC;
    from_fir_right : out STD_LOGIC_VECTOR ( 15 downto 0 );
    from_fir_valid : out STD_LOGIC;
    to_fir : in STD_LOGIC_VECTOR ( 31 downto 0 );
    to_fir_valid : in STD_LOGIC;
    addra : in STD_LOGIC_VECTOR ( 10 downto 0 );
    dina : in STD_LOGIC_VECTOR ( 15 downto 0 );
    douta : out STD_LOGIC_VECTOR ( 15 downto 0 );
    wea : in STD_LOGIC_VECTOR ( 0 to 0 )
  );
  end component lp200_spdif;
   
  component spdif_out is 
  generic (
    C_DELAY_LEFT : std_logic_vector(9 downto 0);
    C_DELAY_RIGHT : std_logic_vector(9 downto 0)
  );
  port (
    sys_clk : IN  STD_LOGIC;
    spdif_clk : IN std_logic;
    reset : IN std_logic;
    to_fir_valid : OUT std_logic;
    from_fir_valid : IN std_logic;
    from_fir_left : IN std_logic_vector(15 downto 0);
    from_fir_right : IN std_logic_vector(15 downto 0);
    addra : out STD_LOGIC_VECTOR ( 10 downto 0 );
    dina : out STD_LOGIC_VECTOR ( 15 downto 0 );
    douta : in STD_LOGIC_VECTOR ( 15 downto 0 );
    wea : out STD_LOGIC_VECTOR ( 0 to 0 );
    spdif : out  STD_LOGIC
  );
  end component spdif_out;
 
  signal to_fir_valid_s : std_logic;
  signal from_fir_valid_s : std_logic;
  signal from_fir_left_s : std_logic_vector(15 downto 0);
  signal from_fir_right_s : std_logic_vector(15 downto 0);  
  
  signal addra_s : STD_LOGIC_VECTOR ( 10 downto 0 );
  signal dina_s : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal douta_s : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal wea_s : STD_LOGIC_VECTOR ( 0 to 0 );
  
begin

  lp200_spdif_i: component lp200_spdif
    port map (
     addra => addra_s,
     dina => dina_s,
     douta => douta_s,
     from_fir_left => from_fir_left_s,
     from_fir_right => from_fir_right_s,
     from_fir_valid => from_fir_valid_s,
     sys_clk => sys_clk,
     to_fir => to_fir,
     to_fir_valid => to_fir_valid_s,
     wea => wea_s
   );
    
   spdif_out_i: component spdif_out 
     generic map (
       C_DELAY_LEFT => C_DELAY_LEFT,
       C_DELAY_RIGHT => C_DELAY_RIGHT
     )
     port map (
       sys_clk => sys_clk,
       spdif_clk => spdif_clk,
       reset => reset,
       to_fir_valid => to_fir_valid_s,
       from_fir_valid => from_fir_valid_s,
       from_fir_left => from_fir_left_s,
       from_fir_right => from_fir_right_s,
       addra => addra_s,
       dina => dina_s,
       douta => douta_s,
       wea => wea_s,
       spdif => spdif
     );
end STRUCTURE;
