/* Epiphany-specific data structures */

#include <stdint.h>

enum ep_state {
	EP_HALT,
	EP_IDLE,
	EP_RUNNING,
	EP_TRAP,
};

enum ep_fpu {
	EP_FLOAT,
	EP_INTEGER,
};

enum ep_tmode {
	EP_OFF       = 0,
	EP_CLK       = 1,
	EP_IDLECLK   = 2,
	EP_IALU      = 4,
	EP_FPU       = 5,
	EP_DUAL      = 6,
	EP_STALL_E1  = 7,
	EP_STALL_RA  = 8,
	EP_STALL_LMF = 10,
	EP_STALL_LML = 11,
	EP_STALL_EF  = 12,
	EP_STALL_EL  = 13,
	EP_MESH0     = 14,
	EP_MESH1     = 15,
};

struct ep_tmode_text {
	char letter;
	char *string;
};

struct ep_core {
	int           row, col;
	enum ep_state state;
	int           trap;
	enum ep_fpu   fpu;
	int           interrupts;
	int           excause;
	int           timers[2];
	enum ep_tmode tmodes[2];
	uint32_t      tvalues[2];
	uint32_t      pc;
	char*         funcname;
	char*         srcline;
};

/* functions used by menu system */
void ep_show_actions(void);
int ep_action(int, int, int);
