/* e-top
   ugly tool to watch Epiphany state */

#include <stdio.h>
#include <errno.h>
#include <ncurses.h>

#include <sys/time.h>
#include <time.h>

#include <e-hal.h>

#include "main.h"

#define TIME_DIFF(A,B) \
	(((B.tv_sec*1000000 + B.tv_usec) - (A.tv_sec*1000000 + A.tv_usec)))

/* parameter variables */
int   opt_batch = 0, opt_num = 0, opt_numelfs;
float opt_secs = 1;
char* opt_elfs[CORES];

/* main function */
int main(int argc, char *argv[])
{
	e_epiphany_t dev;
	int running = 1;

	/* parse command line */
	if(parse_opts(argc, argv))
		return(1);

	/* Epiphany initialization */
	if(e_init(NULL) != E_OK) {
		fprintf(stderr, "Error in e_init().\n");
		return(2);
	}
	if(e_open(&dev, 0, 0, 4, 4) != E_OK) {
		fprintf(stderr, "Error in e_open().\n");
		return(2);
	}

	/* store 'dev' in epiphany.c */
	select_epiphany(&dev);

	/* NCurses initialization */
	if(!opt_batch) {
		initscr();		/* enable curses mode */
		cbreak();		/* no line buffering, with signals */
		noecho();		/* no terminal echo */
		keypad(stdscr, TRUE);	/* enable arrow and function keys */
		nodelay(stdscr, TRUE);	/* make getch() non-blocking */
		if(has_colors() == FALSE) {
			endwin();
			fprintf(stderr, "Needs a color-capable terminal.\n"
				"Try batch-mode instead.\n");
			return(1);
		}
		xclear();		/* clear screen */

		/* color definitions */
		start_color();
		init_pair(1, COLOR_WHITE, COLOR_BLACK);
		init_pair(2, COLOR_WHITE, COLOR_RED);
		init_pair(3, COLOR_BLACK, COLOR_YELLOW);
		init_pair(4, COLOR_BLACK, COLOR_GREEN);
		init_pair(5, COLOR_WHITE, COLOR_BLUE);
	}

	/* main loop */
	while(running) {
		int got_key = 0;
		int itertime;
		struct timeval tvs[10];

		/* measure time */
		gettimeofday(&tvs[0], NULL);

		/* print header */
		print_header();

		/* access epiphany registers */
		update_states();

		/* print states */
		print_states();

		/* calculate and display iteration time */
		gettimeofday(&tvs[1], NULL);
		itertime = TIME_DIFF(tvs[0], tvs[1]);
		xprintf("[TIME:%7u us]\n", itertime);

		/* refresh screen */
		xrefresh();

		/* check and handle key presses */
		if(!opt_batch) {
			int key;
			do {
				key = getch();
				switch(key) {
				case ERR:
					break;
				case KEY_RESIZE:
					xclear();
					break;
				default:
					got_key = 1;
					running = handle_key(key);
					break;
				}
			} while(key != ERR);
		}

		/* wait unless someone pressed a key */
		if(!got_key) {
			float rem = (1000000 * opt_secs - itertime) / 1000000;
			xdelay(rem);
		}

		/* end if number of displays reached */
		if(opt_num > 0 && --opt_num == 0)
			break;
	}

	/* Shutdown */
	if(!opt_batch) endwin();	/* NCurses  */
	e_close(&dev);			/* Epiphany */

	return(0);
}
