/* e-top header file */

#include <e-hal.h>

/* some definitions */
#define VERSION 1
#define CORES_X 4
#define CORES_Y 4
#define CORES   (CORES_X * CORES_Y)

/* Option parsing */
extern int opt_batch, opt_num, opt_numelfs;
extern float opt_secs;
extern char* opt_elfs[CORES];
int parse_opts(int, char **);

/* NCurses wrappers */
int xprintf(const char *, ...);
int xrefresh(void);
int xclear(void);
int xclrtoeol(void);
int xmove(int, int);
int xattron(int);
int xattroff(int);
void xdelay(float);	/* not strictly ncurses, but who cares? */

/* Input and menu handling */
int handle_key(int key);

/* Epiphany functions */
void select_epiphany(e_epiphany_t *);
void print_header(void);
void update_states();
void print_states();

